/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Hallyson Melo <hallyson.melo@indt.org.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#include <stdlib.h>

#include "nm_usb_utils.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

gboolean
nm_usb_utils_is_loaded ()
{
    gint status;

    /* Verifies the g_ether status */
    status = system("sudo /usr/sbin/nm-usb-setup status");
    g_debug("[%s] - Status: %d", __FUNCTION__, status);
    return status == 0;
}

gboolean
nm_usb_utils_load (const gchar *gw)
{
    gint status = system("sudo /usr/sbin/nm-usb-setup start");

    return status == 0;
}

gboolean
nm_usb_utils_unload (void)
{
    gint status = system("sudo /usr/sbin/nm-usb-setup stop");

    return status == 0;
}

gboolean
nm_usb_utils_put_in_charging_only_mode (void)
{
    gint status = system("sudo /usr/sbin/nm-usb-setup charging_only");

    return status == 0;
}

gboolean 
nm_usb_utils_put_in_host_mode (void)
{
#ifdef DIABLO
    gint status = system("sudo /usr/sbin/nm-usb-setup host");
#endif
#ifdef FREMANTLE
    gint status = system("sudo /usr/sbin/nm-usb-setup suite");
#endif	
    return status == 0;
}

gboolean
nm_usb_utils_is_host_mode ()
{
	gint status = 1;
	
#ifdef FREMANTLE
    status = system("sudo /usr/sbin/nm-usb-setup suite_status");
    g_debug("[%s] - Status: %d", __FUNCTION__, status);
#endif
    
    return status == 0;
}

gboolean
nm_usb_utils_is_charging_only ()
{
	gint status = 1;
	
#ifdef FREMANTLE
    status = system("sudo /usr/sbin/nm-usb-setup charging_only_status");
    g_debug("[%s] - Status: %d", __FUNCTION__, status);
#endif
    
    return status == 0;
}


gboolean 
nm_usb_utils_put_in_otg_mode (void)
{
#ifdef DIABLO
    gint status = system("sudo /usr/sbin/nm-usb-setup otg");
#endif
#ifdef FREMANTLE
    gint status = nm_usb_utils_unload();
#endif
    return status == 0;
}

