/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Hallyson Melo <hallyson.melo@indt.org.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef __NM_CONN_WIDGET_H__
#define __NM_CONN_WIDGET_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define NM_CONN_WIDGET_SETTINGS_CHANGED     "settings-changed"


#define NM_CONN_WIDGET_TYPE            (nm_conn_widget_get_type ())
#define NM_CONN_WIDGET(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_CONN_WIDGET_TYPE, NmConnWidget))
#define NM_CONN_WIDGET_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NM_CONN_WIDGET_TYPE, NmConnWidgetClass))
#define IS_NM_CONN_WIDGET(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_CONN_WIDGET_TYPE))
#define IS_NM_CONN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_CONN_WIDGET_TYPE))
#define NM_CONN_WIDGET_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_CONN_WIDGET_TYPE, NmConnWidgetClass))

typedef struct _NmConnWidget      NmConnWidget;
typedef struct _NmConnWidgetClass NmConnWidgetClass;

struct _NmConnWidgetClass
{
    GtkDialogClass parent_class;

    gboolean (*apply_changes) (NmConnWidget *self);
};

struct _NmConnWidget
{
    GtkDialog parent;
};

GType    nm_conn_widget_get_type (void);
gboolean nm_conn_widget_apply_changes (NmConnWidget *);
gboolean nm_conn_widget_apply_changes_b (NmConnWidget *);
void     nm_conn_widget_settings_changed (gpointer);

G_END_DECLS

#endif
