#!/usr/bin/env python
#coding:utf-8

# Download subtitles from opensubtitles.org (nautilus version)
# Default language is english, to change the language change sublanguageid parameter
# in the searchlist.append function

# Carlos Acedo (carlos@linux-labs.net)
# Inspired on subdownloader
# License GPL v2

# ported to maemo by int_ua (xintx.ua@gmail.com)
# TODO:
#open new dialogs until user cancels selection?
#multiple files selection - set_select_multiple
#i18n - os.environ('LC_MESSAGES')
VERSION="0.3.0"

#import os
from os import environ,system,path
from struct import calcsize,unpack
from sys import argv #
from xmlrpclib import ServerProxy, Error
from gtk import FileChooserDialog #
from commands import getoutput

class opensubtitle():
	def __init__(self,verbose=True,debug=False):
		from dbus import SystemBus,Interface
		self.bus = SystemBus()
		self.dbus_object = self.bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		self.notification = Interface(self.dbus_object, 'org.freedesktop.Notifications')
		self.subslang='eng'
		self.verbose=verbose
		self.debug=debug

	def message(self,text,force=False):
		text = 'opensubtitles: '+str(text)
		if not(self.verbose): return
		if self.debug: force=True
		try:
			if not(force): self.notification.SystemNoteInfoprint(text)
			if force: self.notification.SystemNoteDialog(text, 0, 'OK')
			#(notification.SystemNoteInfoprint,notification.SystemNoteDialog)[force](((text),(text, 0, 'OK'))[force])
		except:
			system('zenity --info --text="'+text+'"')
	def error(self,text):
		self.message("\nError:\n"+text,1)
	def main(self):
		pass
	def select(self,foldername="/home/user/MyDocs/.videos",forced_buttons=False):
		if forced_buttons: buttons_list=forced_buttons
		else: buttons_list=("and Switch language",5,"or Search eng. subs",True)
		d = FileChooserDialog("Choose video file",None,action=0,buttons=buttons_list)
		try: d.set_current_folder(foldername)
		except Exception,e:
			if self.debug: self.message("While setting current folder:\n"+str(e))
		response=d.run()
		if response==5:
			self.subslang = getoutput('zenity --entry --text="Search subtitles with next language code: " --entry-text="eng" --title="?"')
			if self.subslang in (None,"",False): return False
			response=True
		if response==True:
			filename=d.get_filename()
			d.destroy()
			return filename
		else:
			d.destroy()
			return False
	def hashFile(self,name):
		try:
			longlongformat = 'LL'  # signed long, unsigned long
			bytesize = calcsize(longlongformat)

			f = open(name, "rb")

			filesize = path.getsize(name)
			hash = filesize

			if filesize < 65536 * 2:
				self.message('File is too small.')
				return "SizeError"

			for x in range(65536/bytesize):
				buffer = f.read(bytesize)
				(l2, l1)= unpack(longlongformat, buffer)
				l_value = (long(l1) << 32) | long(l2)
				hash += l_value
				hash = hash & 0xFFFFFFFFFFFFFFFF #to remain as 64bit number


				f.seek(max(0,filesize-65536),0)
			for x in range(65536/bytesize):
				buffer = f.read(bytesize)
				(l2, l1) = unpack(longlongformat, buffer)
				l_value = (long(l1) << 32) | long(l2)
				hash += l_value
				hash = hash & 0xFFFFFFFFFFFFFFFF

			f.close()
			returnedhash =  "%016x" % hash
			return returnedhash

		except(IOError):
			self.error("Input/Output error while reading file hash")
			return "IOError"
	def get(self,filename,serveraddress="http://api.opensubtitles.org/xml-rpc",forced_subslang=False,loginlang="en"):
		try:
			server = ServerProxy(serveraddress)
			if forced_subslang: self.subslang = forced_subslang
			self.message("creating hash for a file")
			myhash = self.hashFile(filename)
			size = path.getsize(filename)
			self.message("Opening connection.\nLanguage: "+self.subslang+"\nServer: "+serveraddress)
			session = server.LogIn("","",loginlang,"python")
			token = session["token"]
			searchlist = []
			searchlist.append({'sublanguageid':self.subslang,'moviehash':myhash,'moviebytesize':str(size)})
			self.message("searching on a server")
			moviesList = server.SearchSubtitles(token, searchlist)
			try:
		#		print moviesList['data']
				kdialog_items = ''
				for item in moviesList['data']:
					kdialog_items = kdialog_items + '"' + item['SubFileName'] + '" '

				resp = os.popen('zenity --list --text="Select subtitle" --column="Subtitles" ' + kdialog_items).readline()
				if resp != '':
					index = 0
					subIndex = 0
					for item in moviesList['data']:
						if item['SubFileName'] == resp :
							subIndex = index
						else:
							index = index + 1

					subFileName = path.basename(filename)[:-3] + moviesList['data'][subIndex]['SubFileName'][-3:]
					subDirName = path.dirname(filename)
					subURL = moviesList['data'][subIndex]['SubDownloadLink']
					response = system('wget -O - ' + subURL + ' | gunzip  > "' + subDirName + '/' + subFileName + '"' )
					print 'wget -O - ' + subURL + ' | gunzip  > "' + subDirName + '/' + subFileName + '"'
					if response == 0:
						self.message("Subtitles " + subDirName + "/" + subFileName +" successfully saved.",1)
					else:
						self.error("An error ocurred downloading or writing the subtitle")

			except Exception,exc:
				self.message("No subtitles found.\n",1)
			except ProtocolError,pe:
				self.error("Protocol error. Maybe server is down for maintenance?\n"+str(pe))
			self.message("logging out of server")
			server.Logout(session["token"])
			self.message("logged out. Closing")
		except Exception, v:
			print "Error: "+str(v)
			self.error(str(v))

if __name__ == "__main__":
	if "--version" in argv:
		print VERSION
		exit()
	body = opensubtitle()
	try:
		filename = argv[1]
		if environ.__contains__('NAUTILUS_SCRIPT_SELECTED_FILE_PAHS'):
			filename = environ['NAUTILUS_SCRIPT_SELECTED_FILE_PATHS'].strip('\n')
	except:
		filename = body.select()
	if filename in (None,"",False):
		exit()
	body.get(filename)