/* $Id: gfx.h 2375 2011-08-15 13:31:50Z truebrain $ */

/** @file src/gfx.h Graphics definitions. */

#ifndef GFX_H
#define GFX_H

enum {
	SCREEN_WIDTH  = 320, /*!< Width of the screen in pixels. */
	SCREEN_HEIGHT = 200  /*!< Height of the screen in pixels. */
};

extern uint16 g_screenActiveID;

extern void GFX_Init();
extern void GFX_Uninit();
extern uint16 GFX_Screen_SetActive(uint16 screenID);
extern void *GFX_Screen_GetActive();
extern uint16 GFX_Screen_GetSize_ByIndex(uint16 screenID);
extern void *GFX_Screen_Get_ByIndex(uint16 screenID);

extern void GFX_DrawSprite(uint16 spriteID, uint16 x, uint16 y, uint8 houseID);
extern void GFX_Init_SpriteInfo(uint16 widthSize, uint16 heightSize);
extern void GFX_PutPixel(uint16 x, uint16 y, uint8 colour);
extern void GFX_Screen_Copy2(int16 xSrc, int16 ySrc, int16 xDst, int16 yDst, int16 width, int16 height, uint16 memBlockSrc, uint16 memBlockDst, bool skipNull);
extern void GFX_Screen_Copy(int16 xSrc, int16 ySrc, int16 xDst, int16 yDst, int16 width, int16 height, uint16 memBlockSrc, uint16 memBlockDst);
extern void GFX_ClearScreen();
extern void GFX_SetPalette(uint8 *palette);
extern uint8 GFX_GetPixel(uint16 x, uint16 y);
extern uint16 GFX_GetSize(int16 width, int16 height);
extern void GFX_CopyFromBuffer(int16 left, int16 top, uint16 width, uint16 height, uint8 *buffer);
extern void GFX_CopyToBuffer(int16 left, int16 top, uint16 width, uint16 height, uint8 *buffer);

#endif /* GFX_H */
