#ifndef YTXMLPARSER_H
#define YTXMLPARSER_H

#include <QXmlStreamReader>
#include <QList>
#include <QStringList>
#include <QMap>

class YtxmlParser : public QXmlStreamReader
{
public:
    YtxmlParser();
    bool moreResults;
    bool readData(const QByteArray &data);
    QList< QMap<QString, QString> > getVideos();
    bool readSuggestion(const QByteArray &data);
    QStringList getSuggestion();
    bool readPlaylistsData(const QByteArray &data);
    QList< QMap<QString, QString> > getPlaylists();

private slots:
    void readEntry();
    QString formatedDate(const QString&);
    QString formatedRating(const QString&);
    QString formatedDuration(const QString&);

private:
    QMap<QString, QString> video;
    QList< QMap<QString, QString> > videos;
    QList< QMap<QString, QString> > playlists;
    QStringList choices;
};

#endif // YTXMLPARSER_H
