#ifndef NETWORKACCESS_H
#define NETWORKACCESS_H

#include <QObject>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QStringList>
#include <QPixmap>
#include "ytxmlparser.h"

class NetworkAccess : public QObject
{
    Q_OBJECT
public:
    explicit NetworkAccess(QObject *parent = 0);
    virtual ~NetworkAccess();

signals:
    void videoUrl(const QString&);
    void videoData(const QMap<QString, QString>&);
    void playlistsData(const QList< QMap<QString, QString> >&);
    void subscriptionsData(const QList< QMap<QString, QString> >&);
    void videoThumbnail(int, const QPixmap&);
    void dataLoaded(bool);
    void thumbnailLoaded();
    void suggestion(const QStringList&);
    void authDone(bool);
    void postMessage(const QString&);
    void errorMessage(const QString&);

public slots:
    void resetIndex();
    void getUrl(const QUrl&);
    void delUrl(const QUrl&, bool, bool);
    void setUsePreferredServer(bool);
    void getVideoUrl(const QString&);
    void requestAuthenticated(const QString&, const QString&);
    void sign_out();
    void subscribeRequest(const QString&);
    void toPlaylist(const QString&, const QString&);
    void createNewPlaylist(const QString&, const QString&, const QString&, bool, bool);
    void toFavorite(const QString&);
    void rateVideo(const QString&, bool);
    void batchRequest(const QStringList &videoIds);
    void addComments(const QString &urlString, const QString &comment);

private slots:
    void processReply(QNetworkReply*);
    void preloadThumbnail(const QStringList&);
    void parseYtData(QNetworkReply*);
    void processVideoUrl(QNetworkReply*);
    void processAuthenication(QNetworkReply*);
    void postUrl(const QUrl&, const QByteArray&);
    void processPostReply(QNetworkReply*);

private:
    bool usePreferredServer, isAuthenicated, updatePlaylist, updateSubscription;
    QString currentRequestUrl, authUrl, authentication_token, acct, acctpsswd, developer_key, videoIdToPlaylist;
    QStringList imgUrlList;
    QNetworkAccessManager nam;
};

#endif // NETWORKACCESS_H
