#include <QtGui>
#include "playlistdlg.h"

PlayListDlg::PlayListDlg(const QString &id, QWidget *parent) :
    QDialog(parent)
{
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    listWidget = new QListWidget(this);
    listWidget->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    connect(listWidget, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(playlistItemClicked(QListWidgetItem*)));
    newPlaylistP = new QPushButton(tr("Add new"), this);
    newPlaylistH = new QPushButton(tr("Add new"), this);
    connect(newPlaylistP, SIGNAL(clicked()), this, SLOT(addNewPlaylist()));
    connect(newPlaylistH, SIGNAL(clicked()), this, SLOT(addNewPlaylist()));
    QGridLayout *mainLayout = new QGridLayout;
    mainLayout->setColumnStretch(0,1);
    mainLayout->addWidget(listWidget, 0, 0);
    mainLayout->addWidget(newPlaylistH, 0, 1, Qt::AlignTop|Qt::AlignRight);
    mainLayout->addWidget(newPlaylistP, 1, 0);
    setLayout(mainLayout);
    setWindowTitle("Choose your playlist");
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    orientationChanged();
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
    videoId = id;
}

void PlayListDlg::showPlaylists(const QList< QMap<QString, QString> > &playlists)
{
    if(playlists.isEmpty()) {
        emit newPlaylistInfo(videoId);
        QTimer::singleShot(0, this, SLOT(reject()));
    }
    listWidget->clear();
    for (int i =0; i < playlists.size(); ++i){
        QMap<QString, QString> playlist = playlists.at(i);
        listWidget->addItem(QString("%1. %2 (%3 videos)").arg(i + 1).arg(playlist.value("title")).arg(playlist.value("countHint")));
        playlistIDlist.append(playlist.value("playlistId"));
    }
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
}

void PlayListDlg::playlistItemClicked(QListWidgetItem *item)
{
    emit playlistID(videoId, playlistIDlist.at(listWidget->row(item)));
    QTimer::singleShot(0, this, SLOT(accept()));
}

void PlayListDlg::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()){
        resize(800, 340);
        newPlaylistP->hide();
        newPlaylistH->show();
    }
    else {
        resize(480, 340);
        newPlaylistP->show();
        newPlaylistH->hide();
    }
}

void PlayListDlg::addNewPlaylist()
{
    emit newPlaylistInfo(videoId);
    QTimer::singleShot(0, this, SLOT(accept()));
}
