#ifndef NEWPLAYLISTDIALOG_H
#define NEWPLAYLISTDIALOG_H

#include <QtGui>
#include <QWidget>
#include <QDialog>
#include <QCheckBox>
#include <QLineEdit>
#include <QTextEdit>

class NewPlayListDialog : public QDialog
{
    Q_OBJECT
public:
    explicit NewPlayListDialog(const QString&, QWidget *parent = 0);

signals:
    void playlistInfo(const QString&, const QString&, const QString&, bool, bool);

private slots:
    void orientationChanged();
    void createNewPlaylist();

private:
    QLabel *title, *description;
    QLineEdit *edlTitle;
    QTextEdit *edlDescription;
    QCheckBox *privateOption;
    QDialogButtonBox *saveButtonL, *saveButtonP;
    QString videoId;
};

#endif // NEWPLAYLISTDIALOG_H
