#include "networkaccess.h"

NetworkAccess::NetworkAccess(QObject *parent) :
    QObject(parent)
{
    developer_key = "AI39si5M-9Zwx2cPRoFCdvDtXAYxYW_yoLxi0pzCPUCIv4r1CMM2T3bn_pQvW8KpBiEH0nMSxDVjlR5x0T81Va2Etlq-a3vRXg";
    acct = "";
    acctpsswd = "";
    authUrl = "https://www.google.com/accounts/ClientLogin";
    isAuthenicated = false;
    usePreferredServer = false;
    updatePlaylist = false;
    updateSubscription = false;
    videoIdToPlaylist = "";
    connect(&nam, SIGNAL(finished(QNetworkReply*)), this, SLOT(processReply(QNetworkReply*)));
}
NetworkAccess::~NetworkAccess()
{
}
void NetworkAccess::addComments(const QString &urlString, const QString &comment)
{
    QUrl url(urlString);
    QString content = QString("<?xml version='1.0' encoding='UTF-8'?>\r\n<entry xmlns='http://www.w3.org/2005/Atom' xmlns:yt='http://gdata.youtube.com/schemas/2007'>\r\n<content>%1</content>\r\n</entry>").arg(QString(comment.toAscii().toPercentEncoding(" \n\t#[]{}=+$&*()<>@|',/!\":;?")));
    QByteArray body;
    body.append(content);
    postUrl(url, body);
}

void NetworkAccess::batchRequest(const QStringList &videoIds)
{
    QUrl url("https://gdata.youtube.com/feeds/api/videos/batch?fields=link(@rel),entry(id,link(@rel,@href),summary,gd:comments,media:group(media:credit/text(),media:description/text(),media:title/text(),media:thumbnail[@yt:name='hqdefault'](@url),yt:duration,yt:uploaded,yt:videoid),gd:rating(@average),yt:statistics(@viewCount),yt:rating)");
    QString content = "<feed xmlns='http://www.w3.org/2005/Atom' xmlns:media='http://search.yahoo.com/mrss/' xmlns:batch='http://schemas.google.com/gdata/batch' xmlns:yt='http://gdata.youtube.com/schemas/2007'>\r\n<batch:operation type='query'/>\r\n";
    for (int i = 0; i < videoIds.size(); ++i){
        content.append(QString("<entry>\r\n<id>https://gdata.youtube.com/feeds/api/videos/%1</id>\r\n</entry>\r\n").arg(videoIds.at(i)));
    }
    content.append("</feed>");
    QByteArray body;
    body.append(content);
    postUrl(url, body);
}

void NetworkAccess::subscribeRequest(const QString &username)
{
    QUrl url("https://gdata.youtube.com/feeds/api/users/default/subscriptions");
    QString content = QString("<?xml version='1.0' encoding='UTF-8'?>\r\n<entry xmlns='http://www.w3.org/2005/Atom' xmlns:yt='http://gdata.youtube.com/schemas/2007'>\r\n<category scheme='http://gdata.youtube.com/schemas/2007/subscriptiontypes.cat' term='user'/>\r\n<yt:username>%1</yt:username>\r\n</entry>").arg(username);
    QByteArray body;
    body.append(content);
    postUrl(url, body);
}

void NetworkAccess::toPlaylist(const QString &videoId, const QString &playlistId)
{
    QUrl url(QString("https://gdata.youtube.com/feeds/api/playlists/%1").arg(playlistId));
    QString content = QString("<?xml version='1.0' encoding='UTF-8'?>\r\n<entry xmlns='http://www.w3.org/2005/Atom'>\r\n<id>%1</id>\r\n</entry>").arg(videoId);
    QByteArray body;
    body.append(content);
    postUrl(url, body);
}

void NetworkAccess::createNewPlaylist(const QString &videoId, const QString &title, const QString &summary, bool p, bool update)
{
    updatePlaylist = update;
    videoIdToPlaylist = videoId;
    QString prvt = "";
    if (p){
        prvt.append("<yt:private/>\r\n");
    }
    QUrl url("https://gdata.youtube.com/feeds/api/users/default/playlists");
    QString content = QString("<?xml version='1.0' encoding='UTF-8'?>\r\n<entry xmlns='http://www.w3.org/2005/Atom' xmlns:yt='http://gdata.youtube.com/schemas/2007'>\r\n<title type='text'>%1</title>\r\n<summary>%2</summary>\r\n%3</entry>").arg(QString(title.toAscii().toPercentEncoding(" \n\t#[]{}=+$&*()<>@|',/!\":;?"))).arg(QString(summary.toAscii().toPercentEncoding(" \n\t#[]{}=+$&*()<>@|',/!\":;?"))).arg(prvt);
    QByteArray body;
    body.append(content);
    postUrl(url, body);
}

void NetworkAccess::toFavorite(const QString &videoId)
{
    QUrl url("https://gdata.youtube.com/feeds/api/users/default/favorites");
    QString content = QString("<?xml version='1.0' encoding='UTF-8'?>\r\n<entry xmlns='http://www.w3.org/2005/Atom'>\r\n<id>%1</id>\r\n</entry>").arg(videoId);
    QByteArray body;
    body.append(content);
    postUrl(url, body);
}

void NetworkAccess::rateVideo(const QString &videoId, bool like)
{
    QUrl url(QString("https://gdata.youtube.com/feeds/api/videos/%1/ratings").arg(videoId));
    QString content = QString("<?xml version='1.0' encoding='UTF-8'?>\r\n<entry xmlns='http://www.w3.org/2005/Atom' xmlns:yt='http://gdata.youtube.com/schemas/2007'>\r\n<yt:rating value='%1'/>\r\n</entry>").arg(like?"like":"dislike");
    QByteArray body;
    body.append(content);
    postUrl(url, body);
}

void NetworkAccess::postUrl(const QUrl &url, const QByteArray &content)
{
    QNetworkRequest request(url);
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/atom+xml");
    request.setHeader(QNetworkRequest::ContentLengthHeader, content.length());
    if(isAuthenicated){
        request.setRawHeader("Authorization", QByteArray("GoogleLogin auth=").append(authentication_token));
    }
    request.setRawHeader("GData-Version", "2");
    request.setRawHeader("X-GData-Key", QByteArray("key=").append(developer_key));
    nam.post(request, content);
}

void NetworkAccess::delUrl(const QUrl &url, bool playlistUpdate, bool subscriptionUpdate)
{
    updatePlaylist = playlistUpdate;
    updateSubscription = subscriptionUpdate;
    QNetworkRequest request(url);
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/atom+xml");
    request.setRawHeader("Authorization", QByteArray("GoogleLogin auth=").append(authentication_token));
    request.setRawHeader("GData-Version", "2");
    request.setRawHeader("X-GData-Key", QByteArray("key=").append(developer_key));
    nam.deleteResource(request);
}

void NetworkAccess::getUrl(const QUrl &url)
{
    currentRequestUrl = url.toString();
    QNetworkRequest request;
    request.setUrl(url);
    if (isAuthenicated) {
        request.setRawHeader("Authorization", QByteArray("GoogleLogin auth=").append(authentication_token));
    }
    request.setRawHeader("GData-Version", "2");
    request.setRawHeader("X-GData-Key", QByteArray("key=").append(developer_key));
    nam.get(request);
}

void NetworkAccess::processReply(QNetworkReply *reply)
{
    QString requestUrl = reply->request().url().toString();
    if ((reply->operation() == QNetworkAccessManager::PostOperation || reply->operation() == QNetworkAccessManager::DeleteOperation) && requestUrl != authUrl) {
        processPostReply(reply);
        return;
    }
    else if (requestUrl == currentRequestUrl){
        parseYtData(reply);
    }
    else if (requestUrl == authUrl){
        processAuthenication(reply);
    }
    else {
        if (reply->error() != QNetworkReply::NoError){
            if (requestUrl.endsWith("hqdefault.jpg")) {
                int idx = imgUrlList.indexOf(requestUrl);
                QNetworkRequest request;
                request.setUrl(QUrl(requestUrl.replace("hqdefault.jpg", "default.jpg")));
                imgUrlList.replace(idx, requestUrl);
                nam.get(request);
            }
            reply->deleteLater();
            return;
        }
        QPixmap thumbnail;
        thumbnail.loadFromData(reply->readAll());
        int i = imgUrlList.indexOf(requestUrl);
        if (i != -1){
            emit videoThumbnail(i, thumbnail);
            imgUrlList.replace(i, "");
        }
        reply->deleteLater();
    }
}

void NetworkAccess::processPostReply(QNetworkReply *reply)
{
    int statusCode = reply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt();
    if ((statusCode == 200) || (statusCode == 201)) {
        if (updatePlaylist){
            QUrl url("https://gdata.youtube.com/feeds/api/users/default/playlists?fields=entry(title,content(@src),link[@rel='edit'](@href),yt:countHint,yt:playlistId)");
            getUrl(url);
            updatePlaylist = false;
        }
        if (updateSubscription){
            QUrl url("https://gdata.youtube.com/feeds/api/users/default/subscriptions?fields=entry(title,link[@rel='edit'](@href),yt:countHint,yt:username)");
            getUrl(url);
            updateSubscription = false;
        }
        if (!videoIdToPlaylist.isEmpty()){
            QByteArray xml = reply->readAll();
            int idx = xml.indexOf("<yt:playlistId>") + 15;
            int idx1 = xml.indexOf("</yt:playlistId>", idx);
            xml = xml.mid(idx, idx1 - idx);
            toPlaylist(videoIdToPlaylist, QString(xml));
            videoIdToPlaylist.clear();
        }
        if (reply->request().url().toString() == "https://gdata.youtube.com/feeds/api/videos/batch?fields=link(@rel),entry(id,link(@rel,@href),summary,gd:comments,media:group(media:credit/text(),media:description/text(),media:title/text(),media:thumbnail[@yt:name='hqdefault'](@url),yt:duration,yt:uploaded,yt:videoid),gd:rating(@average),yt:statistics(@viewCount),yt:rating)"){
            currentRequestUrl = "";
            parseYtData(reply);
        }
        else {
            emit postMessage("Success");
        }
    }
    else {
        emit postMessage("Fail");
    }
    reply->deleteLater();
}

void NetworkAccess::preloadThumbnail(const QStringList &urlList)
{
    QNetworkRequest request;
    for (int i = 0; i < urlList.size(); ++i){
        request.setUrl(QUrl(urlList.at(i)));
        nam.get(request);
    }
}

void NetworkAccess::parseYtData(QNetworkReply *reply)
{
    if (reply->error() != QNetworkReply::NoError){
        reply->deleteLater();
        emit errorMessage("Access restricted");
        return;
    }
    YtxmlParser parser;
    if (currentRequestUrl.startsWith("http://google.com/complete/search?output=toolbar&q=")) {
        if(!parser.readSuggestion(reply->readAll())) {
            emit postMessage("Error parsing XML Suggestion");
        }
        else {
            emit suggestion(parser.getSuggestion());
        }
    }
    else if (currentRequestUrl.contains("playlists?")){
        if(!parser.readPlaylistsData(reply->readAll())){
            emit postMessage("Error parsing XML playlist");
        }
        emit playlistsData(parser.getPlaylists());
    }
    else if (currentRequestUrl.contains("subscriptions?")){
        if(!parser.readPlaylistsData(reply->readAll())){
            emit postMessage("Error parsing XML subscription");
        }
        emit subscriptionsData(parser.getPlaylists());
    }
    else {
        if(!parser.readData(reply->readAll())){
            emit postMessage("Error parsing XML standard video feed");
        }
        QList< QMap<QString, QString> > videos = parser.getVideos();
        QStringList thumbUrls;
        if(!videos.isEmpty()){
            for (int i = 0; i < videos.size(); ++i){
                QMap<QString, QString> video = videos.at(i);
                emit videoData(video);
                thumbUrls.append(video.value("thumbnail"));
            }
            emit dataLoaded(parser.moreResults);
            imgUrlList.append(thumbUrls);
            preloadThumbnail(thumbUrls);
        }
        else {
            errorMessage("No video found");
        }
    }
    reply->deleteLater();
}

void NetworkAccess::requestAuthenticated(const QString &usr, const QString &psswd)
{
    acct = usr;
    acctpsswd = psswd;
    QUrl url(authUrl);
    QNetworkRequest request;
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/x-www-form-urlencoded");
    request.setUrl(url);
    QByteArray body;
    body += QString("accountType=HOSTED_OR_GOOGLE&Email=%1&Passwd=%2&service=youtube&source=QTube").arg(usr).arg(psswd);
    nam.post(request, body);
}

void NetworkAccess::sign_out()
{
    acct.clear();
    acctpsswd.clear();
    authentication_token.clear();
    isAuthenicated = false;
}

void NetworkAccess::processAuthenication(QNetworkReply *reply)
{
    if (reply->error() != QNetworkReply::NoError){
        emit postMessage(QString("Authenication error: %1").arg(reply->error()));
    }
    else {
        QStringList lines = QString(reply->readAll()).split("\n", QString::SkipEmptyParts);
        for (int i = 0; i < lines.size(); ++i){
            QStringList tokenList = lines.at(i).split("=");
            if (tokenList.at(0) == "Error") {
                emit postMessage(QString("Authenication error: %1").arg(tokenList.at(1)));
            }
            else if (tokenList.at(0) == "Auth") {
                authentication_token = tokenList.at(1);
                isAuthenicated = true;
                break;
            }
        }
    }
    emit authDone(isAuthenicated);
    reply->deleteLater();
}

void NetworkAccess::getVideoUrl(const QString &videoId)
{
    if (!videoId.isEmpty()){
        QNetworkAccessManager *manager = new QNetworkAccessManager(this);
        QUrl url = QUrl(QString("http://www.youtube.com/get_video_info?video_id=%1&el=vevo&ps=default&gl=US&hl=en").arg(videoId));
        QNetworkRequest request;
        request.setUrl(url);
        connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(processVideoUrl(QNetworkReply*)));
        manager->get(request);
    }
}

void NetworkAccess::processVideoUrl(QNetworkReply *reply)
{
    QNetworkAccessManager *manager = qobject_cast<QNetworkAccessManager*>(sender());
    if (reply->error() != QNetworkReply::NoError){
        emit postMessage(QString("Unable to get video url error: %1").arg(reply->error()));
    }
    else {
        QString mp4url = "";
        QString string = reply->readAll();
        if (string.contains("url_encoded_fmt_stream_map=")){
            QString str(QByteArray::fromPercentEncoding(string.split("url_encoded_fmt_stream_map=").at(1).split("&").at(0).toAscii()));
            QStringList strlist = str.split(",");
            if (strlist.size() > 2) {
                if(strlist.at(strlist.size()-2).endsWith("itag=18")){
                    QString url(QByteArray::fromPercentEncoding(strlist.at(strlist.size()-2).split("&").at(0).split("=").at(1).toAscii()));
                    if (url.startsWith("http://o-o.preferred.") && !usePreferredServer){
                        url.remove("o-o.preferred.").remove(7, url.indexOf(".") - 6);
                    }
                    mp4url = url;
                }
            }
        }
        emit videoUrl(mp4url);
    }
    reply->deleteLater();
    manager->deleteLater();
}

void NetworkAccess::setUsePreferredServer(bool b)
{
    usePreferredServer = b;
}

void NetworkAccess::resetIndex()
{
    imgUrlList.clear();
}
