#ifndef ALARMWINDOW_H
#define ALARMWINDOW_H

#include <QWidget>
#include <QTimer>

namespace Ui {
    class AlarmWindow;
}

class AlarmWindow : public QWidget
{
    Q_OBJECT

public:
    explicit AlarmWindow(QWidget *parent = 0);
    ~AlarmWindow();

public slots:
    void showSettingsDialog();
    void homeScreenChanged(bool isOnCurrentHomescreen);
    void listClicked();
    void fillAlarmList();

protected:
    void mouseReleaseEvent ( QMouseEvent * e );
    void paintEvent(QPaintEvent *event);

private:
    void loadSettings();
    void showClock();
    void updateUi();

private:
    Ui::AlarmWindow *ui;
    int m_numberAlarms;
    int m_width;
    QFont m_font;
    QColor m_color;
    bool m_showCaption;
    bool m_showTitle;
    bool m_showRemain;
    bool m_showRecurrent;
    bool m_showIfEmpty;
    bool m_showDate;
//    bool m_showStdOnly;
    int m_alarmFilter;
    int m_timeFrame;
    float m_transparency;
    QTimer *m_timer;
};

#endif // ALARMWINDOW_H
