#include "munadiengine.h"
#include "settings.h"
#include "mainwindow.h"

MunadiEngine::MunadiEngine(QObject * parent)
    : QObject(parent)
    , hadithList(0)
    , athanObject(0)
    , settings(new Settings())
    , timer(new QTimer(this))
{
    calculatePrayer();
    getNextPrayer();

    timer->setInterval(1000);
    timer->start();

    connect(timer, SIGNAL(timeout()), this, SLOT(checkAthan()));
}
MunadiEngine::~MunadiEngine()
{
    if(athanObject) delete athanObject;
    if(settings)    delete settings;
}
void MunadiEngine::calculatePrayer()
{
    Date date;
    date.day = QDate::currentDate().day();
    date.month = QDate::currentDate().month();
    date.year = QDate::currentDate().year();

    getPrayerTimes(&settings->currentCity.location,
                   &settings->currentCity.method,
                   &date,
                   settings->currentCity.ptList);

    emit stateChanged();
}

QTime MunadiEngine::getFajr()
{
    return QTime(settings->currentCity.ptList[Fajr].hour,
                 settings->currentCity.ptList[Fajr].minute);
}
QTime MunadiEngine::getDuhr()
{
    return QTime(settings->currentCity.ptList[Duhr].hour,
                 settings->currentCity.ptList[Duhr].minute);
}
QTime MunadiEngine::getAsr()
{
    return QTime(settings->currentCity.ptList[Asr].hour,
                 settings->currentCity.ptList[Asr].minute);
}
QTime MunadiEngine::getMagrib()
{
    return QTime(settings->currentCity.ptList[Magrib].hour,
                 settings->currentCity.ptList[Magrib].minute);
}
QTime MunadiEngine::getIsha()
{
    return QTime(settings->currentCity.ptList[Isha].hour,
                 settings->currentCity.ptList[Isha].minute);
}
QTime MunadiEngine::getTest()
{
    return testTime;
}
QTime MunadiEngine::getSunrise()
{
    return QTime(settings->currentCity.ptList[Sunrise].hour,
                 settings->currentCity.ptList[Sunrise].minute);
}

bool MunadiEngine::isAthanPlaying()
{
#ifdef SFML
        if(athanObject == 0) return false;

        if(athanObject->GetStatus() == sf::Music::Playing)
            return true;
        else
            return false;
#else
    if(athanObject == 0)    return false;

    if(athanObject->state() == QMediaPlayer::PlayingState)
        return true;
    else
        return false;
#endif
}

void MunadiEngine::playAthan()
{ 
#ifdef SFML
        if(athanObject == 0)
        {
            QString athanFile;
            athanFile = QApplication::applicationDirPath();
            athanFile += "/audio/athan.wav";
            dout << "Athan file: " << athanFile;

            athanObject = new sf::Music();
            athanObject->OpenFromFile(athanFile.toStdString());
        }

        if(isAthanPlaying())
        {
            dout << "Athan playing, will return.";
            return;
        }

        currentPrayerLabel = nextPrayerLabel;
        athanObject->Play();
        emit athanTriggered();
        emit stateChanged();

#else
        if(athanObject == 0)
        {
            QString athanFile;
            athanFile = QApplication::applicationDirPath();
            athanFile += "/audio/athan.wav";
            dout << "Athan file: " << athanFile;
            athanObject = new QMediaPlayer();
            athanObject->setMedia(QUrl::fromLocalFile((athanFile)));
            athanObject->setVolume(30);
        }

        if(isAthanPlaying())
        {
            dout << "Athan playing, will return.";
            return;
        }

        currentPrayerLabel = nextPrayerLabel;
        athanObject->play();
        emit athanTriggered();
        emit stateChanged();

#endif
}
void MunadiEngine::stopAthan()
{
#ifdef SFML
    athanObject->Stop();
#else
    athanObject->stop();
#endif

    emit stateChanged();
}

QString MunadiEngine::getTimeDifference()
{
    int currentMins = QTime::currentTime().hour() * 60;
    currentMins += QTime::currentTime().minute();

    QTime nextPrayerTime = getNextPrayer();

    int nextPrayerMins = nextPrayerTime.hour() * 60;
    nextPrayerMins += nextPrayerTime.minute();

    QTime time;
    time = time.addSecs(60 * (nextPrayerMins - currentMins));

    return time.toString("H 'hours' m 'minutes'");
}

QTime MunadiEngine::getNextPrayer()
{
    QTime currentTime(QTime::currentTime().hour(),QTime::currentTime().minute(), QTime::currentTime().second());

#ifdef TESTING
    if(currentTime <= getTest())
    {
        dout << "hit test";
        nextPrayerLabel = "Test";
        return getTest();
    }
    else
#endif
    if(currentTime <= getFajr())
    {
        dout<< "HIT FAJR";

        nextPrayerLabel = "Fajr";
        return getFajr();
    }
    else if(currentTime <= getDuhr())
    {
        dout<< "HIT THUHR";

        nextPrayerLabel = "Duhr";
        return getDuhr();
    }
    else if(currentTime <= getAsr())
    {
        dout<< "HIT ASR";

        nextPrayerLabel = "Asr";
        return getAsr();
    }
    else if(currentTime <= getMagrib())
    {
        dout<< "HIT MAGHRIB";

        nextPrayerLabel = "Magrib";
        return getMagrib();
    }
    else if(currentTime <= getIsha())
    {
        dout<< "HIT ISHA";

        nextPrayerLabel = "Isha";
        return getIsha();
    }
    else    // rotated back
    {
        dout<< "HIT FAJR";

        nextPrayerLabel = "Fajr";
        return getFajr();
    }
}

QString MunadiEngine::getNextPrayerLabel()
{
    return nextPrayerLabel;
}

QString MunadiEngine::getCurrPrayerLabel()
{
    return currentPrayerLabel;
}

void MunadiEngine::checkAthan()
{
    dout << "checkAthan() called";

    QTime currentTime(QTime::currentTime().hour(),QTime::currentTime().minute(), QTime::currentTime().second());

    if(currentTime == getNextPrayer())
    {
        playAthan();
        dout << "called paly athan() ...";
    }

    if(currentTime.hour() == 0 && currentTime.minute() == 0 && currentTime.second() == 0)  //if mid-night
    {
        dout << "it is now midnight, updated prayer times..";
        calculatePrayer();
    }

    if(QTime::currentTime().second() == 0)  //every minute, update display.
    {
        emit stateChanged();
    }
}

void MunadiEngine::initHadithList()
{
    if(hadithList == 0)
    {
        QFile file(":/text/hadith");
        if(!file.open(QFile::ReadOnly))
        {
            hadithList = 0;
            return;
        }
        QByteArray buffer;
        buffer = file.readAll();
        QString stringBuffer(buffer);
        hadithList = new QStringList(stringBuffer.split("$$", QString::SkipEmptyParts));
        hadithCount = hadithList->count();
    }
}

QString MunadiEngine::getRandomHadith()
{
    if(hadithList == 0) return "Hadith list not initialised";

    srand(time(0));
    random();
    currentHadithIndex = (rand() % hadithCount);
    dout << "Index ================= " << currentHadithIndex;
    return hadithList->value(currentHadithIndex);
}

QString MunadiEngine::getNextHadith()
{
    if(hadithList == 0) return "Hadith list not initialised";

    if(currentHadithIndex < hadithCount-1)    // Reached end
        return hadithList->value(++currentHadithIndex);
    else
        return hadithList->value(currentHadithIndex);
}

QString MunadiEngine::getPrevHadith()
{
    if(hadithList == 0) return "Hadith list not initialised";

    if(currentHadithIndex > 0)    // Reached end
        return hadithList->value(--currentHadithIndex);
    else
        return hadithList->value(currentHadithIndex);
}

