#include "addcitydialog.h"
#include "ui_addcitydialog.h"
#include "settings.h"

addCityDialog::addCityDialog(MunadiEngine * munadiEngine, QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::addCityDialog)
{
    m_ui->setupUi(this);

    munadi = munadiEngine;
    netManager = new QNetworkAccessManager(this);
    connect(netManager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(netReplyReceived(QNetworkReply*)));
}

addCityDialog::~addCityDialog()
{
    delete m_ui;
}

void addCityDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void addCityDialog::on_btnProbeWS_clicked()
{
    QString query = WEBSERVICE_URL + m_ui->tbLocationAddress->text();
    netManager->get(QNetworkRequest(QUrl(query)));
}
void addCityDialog::netReplyReceived(QNetworkReply * reply)
{
    QByteArray data(reply->readAll());
    if(data.size() == 0 || !isdigit(data[0]))
    {
        QMessageBox::information(this, "Location not found", "The address appears to be invalid or not found.\n"
                                 "Please enter details manually.");
        return;
    }
    foundCity = parseIPLocTools(data);
    displayResults(foundCity);
}
City addCityDialog::parseIPLocTools(QByteArray & data)
{
    QList<QByteArray> results = data.split(',');
    City city;

    city.name = m_ui->tbLocationAddress->text();
    city.location.degreeLat = results[0].toDouble();
    city.location.degreeLong = results[1].toDouble();

    return city;
}
void addCityDialog::displayResults(City & city)
{
    m_ui->tbLocation->setText(city.name);
    m_ui->tbLatitude->setText(QString::number(city.location.degreeLat));
    m_ui->tbLongitude->setText(QString::number(city.location.degreeLong));
}

void addCityDialog::on_buttonBox_accepted()
{
    munadi->settings->setCity(foundCity.name, foundCity.location.degreeLat, foundCity.location.degreeLong,
                             m_ui->sbGmtOffset->value(), m_ui->cbDaylightSaving->isChecked(), 1, 5);
    munadi->calculatePrayer();
    this->close();
}

void addCityDialog::on_buttonBox_rejected()
{
    this->close();
}
