#ifndef OPTIONSDIALOG_H
#define OPTIONSDIALOG_H

#include "data/settings.h"

#include <QDialog>

class QStandardItemModel;
class QMaemo5ListPickSelector;

namespace Ui {
    class OptionsDialog;
}

class OptionsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit OptionsDialog(QWidget *parent = 0);
    ~OptionsDialog();

    void SetSettings(const Settings &settings);
    Settings GetSettings();

public:
    Q_SIGNAL void Accept(const Settings &);
    Q_SIGNAL void Cancel(const Settings &);

private:
    Q_SLOT void Accept();
    Q_SLOT void Cancel();
    Q_SLOT void Rotate();

private:
    Ui::OptionsDialog *ui;
    QStandardItemModel *_rotation_model;
    QMaemo5ListPickSelector *_rotation_selector;
    Settings _settings;
};

#endif // OPTIONSDIALOG_H
