// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef SETTINGS_H
#define SETTINGS_H

#include "location.h"

#include <QString>
#include <QList>

class Settings
{
public:
    typedef QList<Location> Locations;

    enum SearchObjectsType {
        THEATERS,
        MOVIES
    };

    enum OrientationMode {
        LANDSCAPE,
        PORTRAIT,
        AUTOROTATION
    };

public:
    Settings();

    Location GetLocation() const { return _location; }
    void SetLocation(const Location &location) { _location = location; }

    Locations GetPreviousLocations() const  { return _previous_locations; }
    void SetPreviousLocations(const Locations &previous_locations);

    bool IsGPSEnabled() const { return _gps_enabled; }
    void SetGPSEnabled(bool gps_enabled) { _gps_enabled = gps_enabled; }

    SearchObjectsType GetSearchObjectsType() const { return _search_objects_type; }
    void SetSearchObjectsType(SearchObjectsType search_objects_type) { _search_objects_type = search_objects_type; }

    OrientationMode GetOrientationMode() const { return _rotation_mode; }
    void SetOrientationMode(OrientationMode rotation_mode) { _rotation_mode = rotation_mode; }

private:
    Location _location;
    Locations _previous_locations;
    bool _gps_enabled;
    SearchObjectsType _search_objects_type;
    OrientationMode _rotation_mode;
};

#endif // SETTINGS_H
