// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "scheduleentry.h"

#include "data/cinema.h"
#include "data/movie.h"

#include <qhash.h>


ScheduleEntry::ScheduleEntry()
    : _cinema(0),
    _movie(0)
{
}

ScheduleEntry::ScheduleEntry(const Cinema *cinema, const Movie *movie, const QTime &start_time, const QDate &date)
    : _cinema(cinema),
    _movie(movie),
    _start_time(start_time),
    _date(date)
{
}

ScheduleEntryKey ScheduleEntry::GetKey() const
{
    return ScheduleEntryKey(_cinema->GetKey(), _movie->GetKey(), _start_time, _date);
}

bool operator==(const ScheduleEntry &lhs, const ScheduleEntry &rhs)
{
    return lhs.GetCinema() == rhs.GetCinema()
            && lhs.GetMovie() == rhs.GetMovie()
            && lhs.GetStartTime() == rhs.GetStartTime()
            && lhs.GetDate() == rhs.GetDate();
}

uint qHash(const ScheduleEntry &key)
{
    static QTime midnight(0, 0);
    return qHash(key.GetCinema()) + qHash(key.GetMovie()) + qHash(-key.GetStartTime().secsTo(midnight)) + qHash(key.GetDate().toJulianDay());
}
