// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef SETTINGSCONTROLLER_H
#define SETTINGSCONTROLLER_H

#include <QString>
#include <QObject>

class MainWindow;
class Settings;

class SettingsController : public QObject
{
    Q_OBJECT
public:
    SettingsController(MainWindow *main_window, Settings *settings);

    void Load();
    void Save();

    void EmitInitialSettings();

public:
    Q_SIGNAL void SettingsChanged(const Settings &);

public:
    Q_SLOT void OpenSettingsDialog();

private:
    Q_SLOT void AcceptSettingsDialog(const Settings &);
    Q_SLOT void CancelSettingsDialog(const Settings &);

private:
    QString GetSettingsFileName();

private:
    MainWindow *_main_window;
    Settings *_settings;
};

#endif // SETTINGSCONTROLLER_H
