// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "abstractmainwindow.h"
#include "data/location.h"
#include "data/cinemakey.h"
#include "data/moviekey.h"

#include <QModelIndex>

class CinemaSchedule;
class Cinema;
class Movie;
class QAbstractItemModel;
class QMenu;
class QAction;

namespace Ui {
    class MainWindow;
}

class MainWindow : public AbstractMainWindow {
    Q_OBJECT
public:
    explicit MainWindow(const CinemaSchedule *cinema_schedule, QWidget *parent = 0);
    ~MainWindow();

public:
    Q_SLOT void SetLocation(Location location);
    Q_SLOT void SetTheaterModel(QAbstractItemModel *);
    Q_SLOT void SetMovieModel(QAbstractItemModel *);
    Q_SLOT void SetError(QString error_text);

public:
    Q_SIGNAL void SearchTheaters();
    Q_SIGNAL void SearchMovies();
    Q_SIGNAL void OpenLocationDialog();
    Q_SIGNAL void OpenAboutDialog();
    Q_SIGNAL void TheaterSelected(CinemaKey);
    Q_SIGNAL void MovieSelected(MovieKey);
    Q_SIGNAL void CallTheaterByPhone(CinemaKey);
    Q_SIGNAL void FindRouteToTheater(CinemaKey);
    Q_SIGNAL void SearchTheaterInWeb(CinemaKey);
    Q_SIGNAL void SearchMovieInWeb(MovieKey);

private:
    Q_SLOT void TheaterClicked(QModelIndex);
    Q_SLOT void TheaterContextMenuRequested(const QPoint &);
    Q_SLOT void MovieClicked(QModelIndex);
    Q_SLOT void MovieContextMenuRequested(const QPoint &);
    Q_SLOT void CallTheaterByPhone();
    Q_SLOT void FindRouteToTheater();
    Q_SLOT void SearchTheaterInWeb();
    Q_SLOT void SearchMovieInWeb();

protected:
    void changeEvent(QEvent *e);

private:
    CinemaKey GetCinema(const QModelIndex &index);
    MovieKey GetMovie(const QModelIndex &index);
    void ShowContextMenu(const Cinema *, const QPoint &pos);
    void ShowContextMenu(const Movie *, const QPoint &pos);

private:
    Ui::MainWindow *ui;
    const CinemaSchedule *_cinema_schedule;
    QMenu *_theater_context_menu;
    QMenu *_movie_context_menu;
    QAction *_theater_phone_call;
    QAction *_theater_find_route;
    QAction *_theater_search_web;
    QAction *_movie_search_web;
    Location _location;
    QAbstractItemModel *_theater_model;
    QAbstractItemModel *_movie_model;
};

#endif // MAINWINDOW_H
