/*
 *  Microfeed - Backend for accessing feed-based services (utils)
 *  Copyright (C) 2009 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <dbus/dbus.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <gtk/gtk.h>
#include <microfeed-common/microfeedconfiguration.h>
#include <microfeed-subscriber/microfeedsubscriber.h>

#include "configuration.h"

int main(int argc, char** argv) {
	const char* identifier = NULL;
	MicrofeedSubscriber* subscriber;
	DBusError error;
	DBusConnection* connection;

	if (argc < 1 || argc > 2) {
		fprintf(stderr, "Usage: %s [subscriber]\n", (argc > 0 ? argv[0] : "microfeed-configuration"));

		return 1;
	} else if (argc == 2) {
		identifier = argv[1];
	}

	gtk_init(&argc, &argv);
	dbus_error_init(&error);
	connection = dbus_bus_get(DBUS_BUS_SESSION, &error);
	dbus_connection_setup_with_g_main(connection, NULL);
	
	subscriber = microfeed_subscriber_new("org.microfeed.Utils.Configuration", connection);

	show_publishers_dialog(subscriber, NULL, identifier);
	
	microfeed_subscriber_free(subscriber);
	
	return 0;
}
