/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Geolocation.
 *
 * The Initial Developer of the Original Code is Mozilla Corporation
 * Portions created by the Initial Developer are Copyright (C) 2009
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Oleg Romashin <romaxa@gmail.com>  (Original Author)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsCOMPtr.h"
#include "nsAutoPtr.h"
#include "nsCOMArray.h"
#include "nsTArray.h"
#include "nsITimer.h"
#include "nsIObserver.h"
#include "nsIURI.h"

#include "nsWeakPtr.h"
#include "nsCycleCollectionParticipant.h"

#include "nsIGeolocationProvider.h"
#include "nsPIPromptService.h"
#include "nsIWindowWatcher.h"

class MaemoLocationPrompt : public nsIGeolocationPrompt, nsPIPromptService

{
 public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIGEOLOCATIONPROMPT
  NS_DECL_NSPIPROMPTSERVICE

  MaemoLocationPrompt();

 private:
  ~MaemoLocationPrompt();

  nsresult GetLocaleString(const char *aKey, PRUnichar **aResult);
  NS_IMETHODIMP ConfirmEx(nsIDOMWindow *parent,
                          const PRUnichar *dialogTitle, const PRUnichar *text,
                          PRUint32 buttonFlags, const PRUnichar *button0Title,
                          const PRUnichar *button1Title, const PRUnichar *button2Title,
                          const PRUnichar *checkMsg, PRBool *checkValue,
                          PRInt32 *buttonPressed);

  nsCOMPtr<nsIWindowWatcher> mWatcher;
};

//7848125d-488a-49c2-a064-bc4c543bc2d1
#define MaemoLocationPrompt_CID \
{  0x7848125d, 0x488a, 0x49c2, \
{ 0xa0, 0x64, 0xbc, 0x4c, 0x54, 0x3b, 0xc2, 0xd1} }

#define MaemoLocationPrompt_ContractID "@mozilla.org/geolocation/prompt;1"
