#include <tangle/tangle.h>

static void on_clicked(TangleButton* button, gpointer user_data) {
	printf("clicked %s\n", (tangle_button_get_selected(button) ? "(selected)" : ""));
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* normal_texture;
	ClutterActor* active_texture;
	ClutterActor* selected_texture;
	ClutterActor* clickable_button;
	ClutterActor* selectable_button;
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);

	normal_texture = clutter_texture_new_from_file("test_image_100x74.jpg", NULL);
	active_texture = clutter_texture_new_from_file("test_image_135x100.jpg", NULL);

	clickable_button = tangle_button_new_with_background_actors(normal_texture, active_texture);
	clutter_actor_set_position(clickable_button, 100.0, 100.0);
	g_signal_connect(clickable_button, "clicked", G_CALLBACK(on_clicked), NULL);

	normal_texture = clutter_texture_new_from_file("test_image_100x74.jpg", NULL);
	active_texture = clutter_texture_new_from_file("test_image_135x100.jpg", NULL);
	selected_texture = clutter_texture_new_from_file("test_image_selected_100x74.jpg", NULL);

	selectable_button = tangle_button_new_selectable_with_background_actors(normal_texture, active_texture, selected_texture);
	clutter_actor_set_position(selectable_button, 100.0, 300.0);
	g_signal_connect(selectable_button, "clicked", G_CALLBACK(on_clicked), NULL);
	
	clutter_container_add(CLUTTER_CONTAINER(stage), clickable_button, selectable_button, NULL);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
