/*
 * tangle-set-property-action.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_SET_PROPERTY_ACTION_H__
#define __TANGLE_SET_PROPERTY_ACTION_H__

#include "tangle-action.h"

#define TANGLE_TYPE_SET_PROPERTY_ACTION (tangle_set_property_action_get_type())
#define TANGLE_SET_PROPERTY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_SET_PROPERTY_ACTION, TangleSetPropertyAction))
#define TANGLE_IS_SET_PROPERTY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_SET_PROPERTY_ACTION))
#define TANGLE_SET_PROPERTY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_SET_PROPERTY_ACTION, TangleSetPropertyActionClass))
#define TANGLE_IS_SET_PROPERTY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_SET_PROPERTY_ACTION))
#define TANGLE_SET_PROPERTY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_SET_PROPERTY_ACTION, TangleSetPropertyActionClass))

typedef struct _TangleSetPropertyActionPrivate TangleSetPropertyActionPrivate;

typedef struct _TangleSetPropertyAction {
	TangleAction parent_instance;
	TangleSetPropertyActionPrivate* priv;
} TangleSetPropertyAction;

typedef struct _TangleSetPropertyActionClass {
	TangleActionClass parent_class;
} TangleSetPropertyActionClass;

GType tangle_set_property_action_get_type(void) G_GNUC_CONST;

TangleAction* tangle_set_property_action_new();

GObject* tangle_set_property_action_get_object(TangleSetPropertyAction* action);
void tangle_set_property_action_set_object(TangleSetPropertyAction* action, GObject* object);
const gchar*tangle_set_property_action_get_name(TangleSetPropertyAction* action);
void tangle_set_property_action_set_name(TangleSetPropertyAction* action, const gchar* name);
void tangle_set_property_action_get_value(TangleSetPropertyAction* action, GValue* value);
void tangle_set_property_action_set_value(TangleSetPropertyAction* action, const GValue* value);

#endif
