/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    ToolItem lastFocus;
    ToolItem[] tabItemList;
    ImageList imageList;

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        this.style = (n & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int n2 = (n & 0x200) != 0 ? 1 : 0;
        OS.gtk_toolbar_set_orientation(this.handle, n2);
    }

    static int checkStyle(int n) {
        if ((n & 0x40) != 0) {
            n &= 0xFFFFFFBF;
        }
        return n & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_toolbar_new();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 0x800000) != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, "swt-toolbar-flat", true);
            OS.gtk_widget_set_name(this.handle, byArray);
        }
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        return this.computeNativeSize(this.handle, n, n2, bl);
    }

    @Override
    Widget computeTabGroup() {
        int n;
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            for (n = 0; n < toolItemArray.length && toolItemArray[n].control == null; ++n) {
            }
            if (n == toolItemArray.length) {
                return super.computeTabGroup();
            }
        }
        for (n = 0; n < toolItemArray.length && !toolItemArray[n].hasFocus(); ++n) {
        }
        while (n >= 0) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.isTabGroup()) {
                return toolItem;
            }
            --n;
        }
        return super.computeTabGroup();
    }

    @Override
    Widget[] computeTabList() {
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            int n;
            for (n = 0; n < toolItemArray.length && toolItemArray[n].control == null; ++n) {
            }
            if (n == toolItemArray.length) {
                return super.computeTabList();
            }
        }
        Widget[] widgetArray = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return widgetArray;
        }
        ToolItem[] toolItemArray2 = this.tabList != null ? this._getTabItemList() : toolItemArray;
        for (int i = 0; i < toolItemArray2.length; ++i) {
            ToolItem toolItem = toolItemArray2[i];
            Widget[] widgetArray2 = toolItem.computeTabList();
            if (widgetArray2.length == 0) continue;
            Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
            System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
            System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
            widgetArray = widgetArray3;
        }
        if (widgetArray.length == 0) {
            widgetArray = new Widget[]{this};
        }
        return widgetArray;
    }

    @Override
    int eventHandle() {
        return this.fixedHandle;
    }

    @Override
    int enterExitHandle() {
        return this.handle;
    }

    @Override
    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        ToolItem[] toolItemArray = this.getItems();
        if (this.toolTipText == null) {
            for (int i = 0; i < toolItemArray.length; ++i) {
                ToolItem toolItem = toolItemArray[i];
                if (toolItem.toolTipText == null) continue;
                toolItem.setToolTipText(shell2, null);
                toolItem.setToolTipText(shell, toolItem.toolTipText);
            }
        }
    }

    @Override
    boolean forceFocus(int n) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (!toolItem.setFocus()) continue;
            return true;
        }
        return super.forceFocus(n);
    }

    public ToolItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[n];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            if (!toolItemArray[i].getBounds().contains(point)) continue;
            return toolItemArray[i];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int n = OS.gtk_container_get_children(this.handle);
        if (n == 0) {
            return 0;
        }
        int n2 = OS.g_list_length(n);
        OS.g_list_free(n);
        return n2;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        int n = OS.gtk_container_get_children(this.handle);
        if (n == 0) {
            return new ToolItem[0];
        }
        int n2 = OS.g_list_length(n);
        ToolItem[] toolItemArray = new ToolItem[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = OS.g_list_nth_data(n, i);
            Widget widget = this.display.getWidget(n4);
            if (widget == null) continue;
            toolItemArray[n3++] = (ToolItem)widget;
        }
        OS.g_list_free(n);
        if (n3 != toolItemArray.length) {
            ToolItem[] toolItemArray2 = new ToolItem[n3];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, n3);
            toolItemArray = toolItemArray2;
        }
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int n = 0;
        for (int i = 0; i < this.tabItemList.length; ++i) {
            if (this.tabItemList[i].isDisposed()) continue;
            ++n;
        }
        if (n == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] toolItemArray = new ToolItem[n];
        int n2 = 0;
        for (int i = 0; i < this.tabItemList.length; ++i) {
            if (this.tabItemList[i].isDisposed()) continue;
            toolItemArray[n2++] = this.tabItemList[i];
        }
        this.tabItemList = toolItemArray;
        return this.tabItemList;
    }

    @Override
    int gtk_key_press_event(int n, int n2) {
        int n3;
        int n4;
        if (!this.hasFocus()) {
            return 0;
        }
        int n5 = super.gtk_key_press_event(n, n2);
        if (n5 != 0) {
            return n5;
        }
        ToolItem[] toolItemArray = this.getItems();
        int n6 = toolItemArray.length;
        for (n4 = 0; n4 < n6 && !toolItemArray[n4].hasFocus(); ++n4) {
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
        boolean bl = false;
        switch (gdkEventKey.keyval) {
            case 65361: 
            case 65362: {
                bl = false;
                break;
            }
            case 65364: {
                if (0 <= n4 && n4 < n6) {
                    ToolItem toolItem = toolItemArray[n4];
                    if ((toolItem.style & 4) != 0) {
                        Event event = new Event();
                        event.detail = 4;
                        int n7 = toolItem.topHandle();
                        event.x = OS.GTK_WIDGET_X(n7);
                        event.y = OS.GTK_WIDGET_Y(n7) + OS.GTK_WIDGET_HEIGHT(n7);
                        if ((this.style & 0x8000000) != 0) {
                            event.x = this.getClientWidth() - OS.GTK_WIDGET_WIDTH(n7) - event.x;
                        }
                        toolItem.postEvent(13, event);
                        return n5;
                    }
                }
            }
            case 65363: {
                bl = true;
                break;
            }
            default: {
                return n5;
            }
        }
        if ((this.style & 0x8000000) != 0) {
            bl = !bl;
        }
        int n8 = n4;
        int n9 = n3 = bl ? 1 : -1;
        while ((n4 = (n4 + n3 + n6) % n6) != n8) {
            ToolItem toolItem = toolItemArray[n4];
            if (!toolItem.setFocus()) continue;
            return n5;
        }
        return n5;
    }

    @Override
    boolean hasFocus() {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (!toolItem.hasFocus()) continue;
            return true;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            if (toolItem != toolItemArray[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean mnemonicHit(char c) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            int n = toolItemArray[i].labelHandle;
            if (n == 0 || !this.mnemonicHit(n, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            int n = toolItemArray[i].labelHandle;
            if (n == 0 || !this.mnemonicMatch(n, c)) continue;
            return true;
        }
        return false;
    }

    void relayout() {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem == null) continue;
            toolItem.resizeControl();
        }
    }

    @Override
    void releaseChildren(boolean bl) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem == null || toolItem.isDisposed()) continue;
            toolItem.release(false);
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem.control != control) continue;
            toolItem.setControl(null);
        }
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n5 & 0x100) != 0) {
            this.relayout();
        }
        return n5;
    }

    @Override
    void setFontDescription(int n) {
        super.setFontDescription(n);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setFontDescription(n);
        }
        this.relayout();
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setForegroundColor(gdkColor);
        }
    }

    void setTabItemList(ToolItem[] toolItemArray) {
        this.checkWidget();
        if (toolItemArray != null) {
            for (int i = 0; i < toolItemArray.length; ++i) {
                ToolItem toolItem = toolItemArray[i];
                if (toolItem == null) {
                    this.error(5);
                }
                if (toolItem.isDisposed()) {
                    this.error(5);
                }
                if (toolItem.parent == this) continue;
                this.error(32);
            }
            ToolItem[] toolItemArray2 = new ToolItem[toolItemArray.length];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, toolItemArray.length);
            toolItemArray = toolItemArray2;
        }
        this.tabItemList = toolItemArray;
    }

    @Override
    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        Shell shell = this._getShell();
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            String string2 = string != null ? null : toolItemArray[i].toolTipText;
            shell.setToolTipText(toolItemArray[i].handle, string2);
        }
    }
}

