/*
 * vk_parser.c -  parser for MySocials driver
 * This file is part of MSA program
 *
 * Copyright (C) 2009, 2010, 2011 - MySocials team
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#include "parser.h"


/*
 * Parse back url
 *
 * @param inner_req - inner request
 * @param cp - profile
 * @param data - redirect url from server
 * @param data_size - size of url
 * @param response - response in xml
 * @return 0 if login success, 1 if login failure
 */
#ifdef NOT_USE_DEFAULT_WEBAUTH_PARSER
int webauth_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    gchar **params = NULL;
    int i = 0;
    gchar *token = NULL, *uid = NULL;

    if(data != NULL){
        if(g_strcmp0(data, "no_access") == 0){
            *response = g_strdup(MSG_NETWORK_ERROR);
            return 1;
        } else if(g_strcmp0(data, "closed") == 0 || g_strrstr(data, "error=access_denied") != NULL){
            *response = g_strdup(MSG_AUTH_CANCEL);
            return 1;
        } else if (g_strrstr(data, "success") != NULL) {
            params = g_strsplit_set(data, "#&=", 20);
            if (params[0] != NULL){
                while(params[i] != NULL){
                    msa_debug("params[%d]=%s", i, params[i]);
                    if(g_strcmp0(params[i], "access_token") == 0){
                        token = g_strdup(params[i+1]);
                    }
                    if(g_strcmp0(params[i], "x_mailru_vid") == 0){
                        uid = g_strdup(params[i+1]);
                    }
                    i++;
                }
                msa_debug("uid = %s, token = %s", uid, token);
                *response = g_strconcat("<response>", 
                                        "<uid>", uid, "</uid>", 
                                        "<token>", token, "</token>", 
                                        "</response>", NULL);
                msa_debug("response = %s", *response);
                g_strfreev(params);
                g_free(uid);
                g_free(token);
                return 0;
            }
        } 
    } 
    *response = g_strdup(MSG_AUTH_ERROR);
    return 1;
}
#endif

#ifdef NOT_USE_DEFAULT_PROCESS_URL
void process_url(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    xmlNodePtr sig_node = NULL;
    gchar *sig = NULL, *md5_sig = NULL;

    sig_node = xpath_get_node("//InnerRequest/sig", inner_req);
    if (sig_node != NULL){
        sig = (gchar*)xmlNodeGetContent(sig_node);
        md5_sig = g_compute_checksum_for_string(G_CHECKSUM_MD5, sig, strlen(sig));
        g_free(sig);
        *response = g_strconcat(data, "sig=", md5_sig, NULL);
        g_free(md5_sig);
    } else                 
        *response = g_strdup(data);
}
#endif
