<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="UID"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="PRIVATE"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response_users_getInfo"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response_users_getInfo">
    <xsl:element name="{$REQUEST}">
        <xsl:attribute name="class">messages</xsl:attribute>
        <xsl:attribute name="function">getThread</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">threadId</xsl:attribute>
                <xsl:value-of select="/data/Request/Params/string[@name='threadId']"/> 
            </xsl:element> 

	    <xsl:if test="/data/Request/Params/number[@name='page']">
  	      <xsl:element name="{$NUMBER}">
	          <xsl:attribute name="name">page</xsl:attribute>
                  <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
              </xsl:element> 
	    </xsl:if>

	    <xsl:if test="/data/Request/Params/number[@name='pageSize']">
  	      <xsl:element name="{$NUMBER}">
	          <xsl:attribute name="name">pageSize</xsl:attribute>
                  <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
              </xsl:element> 
	    </xsl:if>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">FirstName</xsl:attribute>
                <xsl:value-of select="user/first_name"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">LastName</xsl:attribute>
                <xsl:value-of select="user/last_name"/>
            </xsl:element>

        </xsl:element> 
    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
