<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="UID"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="PRIVATE"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response_photos_getAlbums"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response_photos_getAlbums">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getListAlbums</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">albumList</xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="count(album)"/>
                </xsl:attribute>                             
                <xsl:attribute name="ownerId">
                    <xsl:text>mm</xsl:text>
                    <xsl:value-of select="album/owner"/>
                </xsl:attribute>                             
   
                <xsl:for-each select="album">
                    <xsl:element name="{$STRUCT}">
                        <xsl:attribute name="name">album</xsl:attribute>
                        <xsl:attribute name="id">
                            <xsl:text>mm</xsl:text>
                        <xsl:value-of select="aid"/>
                        </xsl:attribute>
                 
                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">title</xsl:attribute>
                           <xsl:value-of select="title"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">description</xsl:attribute>
                            <xsl:value-of select="description"/>
                        </xsl:element>

                        <xsl:if test="cover_pid">
                            <xsl:if test="cover_pid != '0'">

                                <xsl:element name="{$REQUEST}">
                                    <xsl:attribute name="class">photos</xsl:attribute>
                                    <xsl:attribute name="function">getAlbumIcon</xsl:attribute>
                                    <xsl:element name="{$PARAMS}">
                                        <xsl:attribute name="id">
                                            <xsl:text>mm</xsl:text>
                                            <xsl:value-of select="owner"/>
                                        </xsl:attribute>
                                        <xsl:element name="{$STRING}">
                                            <xsl:attribute name="name">albumId</xsl:attribute>
                                            <xsl:text>mm</xsl:text>
                                            <xsl:value-of select="aid"/>
                                        </xsl:element>
                                        <xsl:element name="{$STRING}">
                                            <xsl:attribute name="name">photoId</xsl:attribute>
                                            <xsl:text>mm</xsl:text>
                                            <xsl:value-of select="cover_pid"/>
                                        </xsl:element>
                                    </xsl:element>
                                </xsl:element>
                            </xsl:if>
                        </xsl:if>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">created</xsl:attribute>
                            <xsl:value-of select="created"/>
                        </xsl:element>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">updated</xsl:attribute>
                            <xsl:value-of select="updated"/>
                        </xsl:element>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">size</xsl:attribute>
                            <xsl:value-of select="size"/>
                        </xsl:element>

                    </xsl:element>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
