/*
 *  Microfeed - Backend for accessing feed-based services
 *  Copyright (C) 2009 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MICROFEEDERROR_H
#define MICROFEEDERROR_H

/**
 * @addtogroup provider libmicrofeed-provider - Modules that are used in the provider side
 * @{
 * @addtogroup MicrofeedError
 *
 * An error message.
 *
 * @{
 */

/**
 * Opaque data type representing an error.
 */
typedef struct _MicrofeedError MicrofeedError;

MicrofeedError* microfeed_error_new(const char* name, const char* message);
void microfeed_error_free(MicrofeedError* error);
const char* microfeed_error_get_name(MicrofeedError* error);
const char* microfeed_error_get_message(MicrofeedError* error);

/**
 * @}
 * @}
 */

#endif
