#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "CTF/src/ctf.h"
#include <driver.h>
#include <interface.h>
#include <parser.h>
#include <driver_config.h>
#include <mysocials_driver.h>
#include <glib.h>

#define XML_RESPONSE_FILE "response.xml"
#define REQUEST_GET_PROFILE "<Request class=\"profile\" function=\"getProfile\"><Params></Params></Request>"

#define REQUEST_SET_SETTINGS "<Request class=\"settings\" function=\"setSettings\"><Params><string name=\"id\">user_id</string><string name=\"token\">token</string></Params></Request>"

#define REQUEST_GET_SETTINGS "<Request class=\"settings\" function=\"getSettings\"><Params></Params></Request>"

#define RESPONSE_WITH_REQUEST "<Response class=\"test\" function=\"test\"><Params><Request class=\"test\" function=\"test\"></Request></Params></Response>"

#define RESPONSE_WITH_REQUEST2 "<Response class=\"test\" function=\"test\"><Params>"REQUEST_GET_SETTINGS"</Params></Response>"

#define JSON_STR1 "{\"mid\":66,\"sid\":\"ee\",\"secret\":\"77\",\"expire\":0,\"sig\":\"ff\"}"
#define XML_STR1 "<?xml version=\"1.0\"?><response><mid>66</mid><sid>ee</sid><secret>77</secret><expire>0</expire><sig>ff</sig></response>"

#define URL_SUCCESS "http://www.flickr.com/"

GLOBAL_DECL();

CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;

CTF_TEST_CASE(apply_parser_test) {

    xmlDocPtr reqXml;
    xmlDocPtr respXml;
    xmlNodePtr node;
    struct ProfileData *cp = NULL;
    gchar* tmp = NULL;

    CTF_TEST_NAME("apply_parser_test1");
    reqXml = NULL;
    respXml = NULL;
    node = NULL;

	cp = profile_create(DRIVER_ID);
    reqXml = xmlParseDoc(REQUEST_GET_PROFILE);

    respXml = apply_parser(reqXml, CTF_TEST_DATA("PARSER_FILE"), cp);

    node = xpath_get_node("//InnerRequest/url", respXml);
    CTF_CHECK(node != NULL);

    node = xpath_get_node("//InnerRequest/params", respXml);
    CTF_CHECK(node != NULL);

    node = xpath_get_node("//InnerRequest/parser", respXml);
    CTF_CHECK(node != NULL);


    CTF_TEST_NAME("apply_parser_test2");
    reqXml = NULL;
    respXml = NULL;

    respXml = apply_parser(reqXml, CTF_TEST_DATA("PARSER_FILE"), cp);

    CTF_CHECK(respXml == NULL);
    
}

CTF_TEST_CASE(json_parser_test) {

    gchar* tmp = NULL;

    CTF_TEST_NAME("json_parser_test1");

    json_parser(NULL, NULL, JSON_STR1, strlen(JSON_STR1), &tmp);

    CTF_CHECK(strcmp(XML_STR1, tmp) == 0);


    CTF_TEST_NAME("json_parser_test2");

    tmp = NULL;
    json_parser(NULL, NULL, NULL, 0, &tmp);

    CTF_CHECK(tmp == NULL);
    
}

CTF_TEST_CASE(profile_check_test) {

    struct ProfileData *cp = NULL;
	cp = profile_create(DRIVER_ID);

    CTF_TEST_NAME("profile_check_test1");

    CTF_CHECK(profile_check(cp) == 1);

    cp->user_id = g_strdup("111");
    cp->token = g_strdup("111");
    CTF_CHECK(profile_check(cp) == 0);

    CTF_TEST_NAME("profile_check_test2");
    CTF_CHECK(profile_check(NULL) == 1);
    
}

CTF_TEST_CASE(profile_update_test) {
    xmlDocPtr reqXml;
    struct ProfileData *cp = NULL;
	cp = profile_create(DRIVER_ID);
    reqXml = xmlParseDoc(REQUEST_SET_SETTINGS);

    CTF_TEST_NAME("profile_update_test1");

    if(profile_update(cp, reqXml) != 1){

        CTF_CHECK(strcmp(cp->user_id, "user_id") == 0);
        CTF_CHECK(strcmp(cp->token, "token") == 0);
    }

    CTF_TEST_NAME("profile_update_test2");
    CTF_CHECK(profile_update(NULL, reqXml) == 1);
    CTF_CHECK(profile_update(cp, NULL) == 1);
    CTF_CHECK(profile_update(NULL, NULL) == 1);
}

CTF_TEST_CASE(xml_request_test) {
     xmlDocPtr reqXml;
    
    CTF_TEST_NAME("request_class_test1");
    char* class;
    char* function;
    reqXml = NULL;
    reqXml = xmlParseDoc(REQUEST_GET_PROFILE);
    class = get_req_class(reqXml);
    function = get_req_function(reqXml);
    CTF_CHECK(!strcmp(class, CTF_TEST_DATA("CLASS_PROFILE")) );
    CTF_CHECK(!strcmp(function, CTF_TEST_DATA("FUNCTION_GET_PROFILE")) );

    CTF_TEST_NAME("request_class_test2");
    reqXml = NULL;
    class = NULL;
    function = NULL;
    class = get_req_class(reqXml);
    function = get_req_function(reqXml);
    CTF_CHECK(class == NULL);
    CTF_CHECK(function == NULL);
    
}


CTF_TEST_CASE(init_test) {
    CTF_TEST_NAME("init_test");
    int res = 0;

    struct ProfileData *cp = profile_create(DRIVER_ID);
    cp->user_id = g_strdup("111");
    cp->token = g_strdup("111");

    res = initialization(cp);
    if(res == 0) {
        CTF_CHECK(cp->user_id != NULL);
        CTF_CHECK(cp->token != NULL);
    } else {
	CTF_CHECK(res == 1);

        CTF_CHECK(cp->user_id == NULL);
        CTF_CHECK(cp->token == NULL);
    }
}


CTF_TEST_CASE(profile_test){
    CTF_TEST_NAME("profile_test");
    
    int num = atoi(CTF_TEST_DATA("NUM_PROFILES"));
    int i, j;
    
    gchar **cpnames = (gchar **)malloc(sizeof(gchar *) * num);
    struct ProfileData *cp;
    
    /* check work with empty profiles */
    j = 0;
    for (i = 0; i < num; i++)
    {
	cp = profile_create(DRIVER_ID);
	if (cp == NULL) {
	    j++;
	    break;
	}
	cpnames[i] = g_strdup(cp->id);
    }
    CTF_CHECK(j == 0);
    
    j = 0;
    for (i = 0; i < num; i+=2)
    {
	g_debug("check profile %s", cpnames[i]);
	cp = profile_get_by_id(cpnames[i]);
	if (cp == NULL) {
	    j++; 
	    break;
	}
    }
    CTF_CHECK(j == 0);
}

CTF_TEST_CASE(shutdown_test){
    CTF_TEST_NAME("module shutdown");
    
    error_type ret;
    struct ProfileData *cp;
    int num = atoi(CTF_TEST_DATA("NUM_PROFILES"));
    int i;
    
    struct msa_module **info = (struct msa_module **)malloc(sizeof(struct msa_module *) * num);
    
    int j = 0;
    for (i = 0; i < num; i++) {
	info[i] = (struct msa_module *)malloc(sizeof(struct msa_module));
    info[i]->id = NULL;
	ret = msa_module_init(info[i]);
	g_debug("current profile: %s", info[i]->id);
	if (ret != SUCCESS)
	{
	    j++;
	    break;
	}
	cp = profile_get_by_id(info[i]->id);
	if (cp == NULL)
	{
	    g_debug("can't found %s", info[i]->id);
	    j++;
	    break;
	}
    }
    CTF_CHECK(j == 0);

    CTF_CHECK(profile_get_by_id("lalala") == NULL);
    CTF_CHECK(profile_get_by_id(info[(int)(num * 0.74)]->id) != NULL);
    
    j = 0;
    for (i = 0; i < num; i +=2) {
	ret = info[i]->shutdown(info[i]);
	if (ret != SUCCESS)
	{
	    j++;
	    break;
	}
	cp = profile_get_by_id(info[i]->id);
	if (cp != NULL)
	{
	    j++;
	    break;
	}
	
    }
    CTF_CHECK(j == 0);

    j = 0;
    for (i = 1; i < num; i +=2) {
	ret = info[i]->shutdown(info[i]);
	if (ret != SUCCESS)
	{
	    
	    j++;
	    break;
	}
	cp = profile_get_by_id(info[i]->id);
	if (cp != NULL)
	{
	    j++;
	    break;
	}
	
    }
    CTF_CHECK(j == 0);
}

CTF_TEST_CASE(driver_send_test){
    CTF_TEST_NAME("driver_send_test1");
    
    xmlDocPtr request = NULL, response = NULL;
    xmlNodePtr node = NULL;
    error_type ret;
    struct ProfileData *cp;
    
    struct msa_module *info = (struct msa_module *)malloc(sizeof(struct msa_module));
    info->id = NULL;
	ret = msa_module_init(info);
	g_debug("current profile: %s", info->id);
    info->proxy = CTF_TEST_DATA("PROXY");
    info->port = atoi(CTF_TEST_DATA("PORT"));

    request = xmlParseDoc(REQUEST_GET_SETTINGS);

    info->send(request, &response, info);

    node = xpath_get_node("//Response", response);
    CTF_CHECK(node != NULL);

    node = xpath_get_node("//Response/Params", response);
    CTF_CHECK(node != NULL);

    CTF_TEST_NAME("driver_send_test2");

    gchar* code = NULL;

    info->send(NULL, &response, info);

    node = xpath_get_node("//Response[@function='errorMessage']/Params/string[@name='code']", response);
    if (node != NULL)
        code = (gchar*)xmlNodeGetContent(node);    

    CTF_CHECK(strcmp(code, DRV_REQ_ERROR_CODE) == 0);

}


CTF_TEST_CASE(process_inner_request_test){
    CTF_TEST_NAME("process_inner_request_test1");
    
    xmlDocPtr request = NULL;
    xmlNodePtr node = NULL;
    gchar* code = NULL;
    struct ProfileData *cp;
    cp = profile_create(DRIVER_ID);
    request = xmlParseDoc(RESPONSE_WITH_REQUEST);

    CTF_CHECK(process_inner_request(cp, request) == 1);
    node = xpath_get_node("//Response[@function='errorMessage']/Params/string[@name='code']", request);
    if (node != NULL)
        code = (gchar*)xmlNodeGetContent(node);    

    CTF_CHECK(strcmp(code, DRV_REQ_ERROR_CODE) == 0);
    
    CTF_TEST_NAME("process_inner_request_test2");

    request = xmlParseDoc(RESPONSE_WITH_REQUEST2);
    CTF_CHECK(process_inner_request(cp, request) == 1);
    node = xpath_get_node("//Response[@class='settings']", request);
    CTF_CHECK(node != NULL);

}

CTF_TEST_CASE(error_message_test){
    CTF_TEST_NAME("error_message_test1");
    
    xmlDocPtr request = NULL;
    xmlNodePtr node = NULL;
    gchar* tmp = NULL;

    error_message("code", &request, "message", "comment");

    node = xpath_get_node("//Response[@function='errorMessage']/Params/string[@name='code']", request);
    tmp = (gchar*)xmlNodeGetContent(node);
    CTF_CHECK(strcmp(tmp, "code") == 0);
    
    node = xpath_get_node("//Response[@function='errorMessage']/Params/string[@name='text']", request);
    tmp = (gchar*)xmlNodeGetContent(node);
    CTF_CHECK(strcmp(tmp, "message") == 0);

    node = xpath_get_node("//Response[@function='errorMessage']/Params/string[@name='comment']", request);
    tmp = (gchar*)xmlNodeGetContent(node);
    CTF_CHECK(strcmp(tmp, "comment") == 0);

}

CTF_TEST_CASE(call_webauth_test){
    CTF_TEST_NAME("call_webauth_test1");
    
    gchar* url = NULL;
    struct ProfileData *cp;
    cp = profile_create(DRIVER_ID);

    url = call_webauth(URL_SUCCESS, cp);
    g_debug("call_webauth");
    if (url != NULL)
        CTF_CHECK(strcmp(url, URL_SUCCESS) == 0);

    CTF_TEST_NAME("call_webauth_test2");
    url = NULL;
    url = call_webauth(URL_SUCCESS, NULL);
    CTF_CHECK(url == NULL);

    url = call_webauth(NULL, cp);
    CTF_CHECK(url == NULL);

}

CTF_TEST_CASE(profile_get_params_test){
    CTF_TEST_NAME("profile_get_params_test1");
    
    gchar* tmp = NULL;
    gchar** params;
    struct ProfileData *cp;
    cp = profile_create(DRIVER_ID);
    cp->user_id = g_strdup("111");
    cp->token = g_strdup("111");

    params = profile_get_params(cp);

    tmp = g_strconcat("\"", SECRET, "\"", NULL);
    CTF_CHECK(strcmp(params[0], "ID") == 0);
    CTF_CHECK(strcmp(params[1], "\"111\"") == 0);
    CTF_CHECK(strcmp(params[2], "TOKEN") == 0);
    CTF_CHECK(strcmp(params[3], "\"111\"") == 0);
    CTF_CHECK(strcmp(params[4], "SECRET") == 0);
    CTF_CHECK(strcmp(params[5], tmp) == 0);

    CTF_TEST_NAME("profile_get_params_test2");
    params = NULL;
    params = profile_get_params(NULL);
    CTF_CHECK(params == NULL);
}


