<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="IMG" select="'img'"/>
<xsl:variable name="FUNCTION" select="/Request/@function"/>  
<xsl:variable name="PARAMS2" select="document('requests.xml')//requests/request[(@function=$FUNCTION) or (@function='general')]"/>  

<xsl:include href="errors.xsl"/>

<xsl:template match="/data/rsp[@stat='ok']">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">profile</xsl:attribute>
        <xsl:attribute name="function">getProfile</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:text>fl</xsl:text>
                <xsl:value-of select="person/@id"/>
            </xsl:attribute>

	<xsl:element name="{$STRING}">
                <xsl:attribute name="name">NickName</xsl:attribute>
                <xsl:value-of select="person/username"/>
            </xsl:element> 

 	<xsl:element name="{$STRING}">
                <xsl:attribute name="name">LastName</xsl:attribute>
                <xsl:value-of select="person/realname"/>
        </xsl:element> 

	<xsl:element name="{$IMG}">
           	<xsl:attribute name="name">Img</xsl:attribute>
		<xsl:choose>
		<xsl:when test="person/@iconserver = '0'">http://www.flickr.com/images/buddyicon.jpg</xsl:when>
        	<xsl:otherwise>http://farm<xsl:value-of select="person/@iconfarm"/>.static.flickr.com/<xsl:value-of select="person/@iconserver"/>/buddyicons/<xsl:value-of select="person/@nsid"/>.jpg</xsl:otherwise>
		</xsl:choose>
	</xsl:element>

        </xsl:element> 
    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
