<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text" indent="yes"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/rsp[@stat='ok']"/>
 <xsl:apply-templates select="/data/rsp[@stat='fail']"/>
</xsl:template>

<xsl:template match="rsp[@stat='ok']">
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">newsList</xsl:attribute>
                <xsl:attribute name="page">
                    <xsl:value-of select="/data/Request/Params/number[@name = 'page']"/>
                </xsl:attribute>
                <xsl:attribute name="pageSize">
                    <xsl:value-of select="/data/Request/Params/number[@name = 'pageSize']"/>
                </xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="count(items/item/activity/event[@type = 'comment'])"/>
                </xsl:attribute>
                <xsl:attribute name="newsType">
                    <xsl:value-of select="/data/Request/Params/string[@name = 'newsType']"/>
                </xsl:attribute>

                <xsl:for-each select="items/item">
                    <xsl:variable name="photoId" select="@id"/>
                    <xsl:variable name="ownerId" select="@owner"/>
                    <xsl:variable name="name" select="title"/>
                    <xsl:variable name="url">http://farm<xsl:value-of select="@farm"/>.static.flickr.com/<xsl:value-of select="@server"/>/<xsl:value-of select="@id"/>_<xsl:value-of select="@secret"/>.jpg</xsl:variable>


                <xsl:for-each select="activity/event[@type = 'comment']">
                    <xsl:element name="{$STRUCT}">
                        <xsl:attribute name="name">news</xsl:attribute>

                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">authorId</xsl:attribute>
               		       <xsl:text>fl</xsl:text>
                           <xsl:value-of select="@user"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">authorName</xsl:attribute>
                           <xsl:value-of select="@username"/>
                        </xsl:element>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">created</xsl:attribute>
                            <xsl:value-of select="@dateadded"/>
                        </xsl:element>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">text</xsl:attribute>
                                <xsl:value-of select="."/>
                            </xsl:element>

                        <xsl:element name="{$STRUCT}">
                            <xsl:attribute name="name">attachment</xsl:attribute>
                            <xsl:attribute name="id">
                   		       <xsl:text>fl</xsl:text>
                               <xsl:value-of select="$photoId"/>     
                            </xsl:attribute>
                            <xsl:attribute name="ownerId">
                   		       <xsl:text>fl</xsl:text>
                               <xsl:value-of select="$ownerId"/>
                            </xsl:attribute>
                            <xsl:attribute name="type">image</xsl:attribute>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">name</xsl:attribute>
                                <xsl:value-of select="$name"/>
                            </xsl:element>

                            <xsl:element name="{$STRING}">
                               <xsl:attribute name="name">urlSmall</xsl:attribute>
                               <xsl:value-of select="$url"/>
                            </xsl:element>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">urlBig</xsl:attribute>
                                <xsl:value-of select="$url"/>
                            </xsl:element>

                        </xsl:element>

                    </xsl:element>
                </xsl:for-each>
            </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
</xsl:template>
</xsl:stylesheet>
