/**
  *      main.cpp
  *
  *      Copyright (C) 2011 Ivaylo Dimitrov <freemangordon@abv.bg>
  *
  *
  *      This program is free software; you can redistribute it and/or modify
  *      it under the terms of the GNU General Public License as published by
  *      the Free Software Foundation; either version 2 of the License, or
  *      (at your option) any later version.
  *
  *      This program is distributed in the hope that it will be useful,
  *      but WITHOUT ANY WARRANTY; without even the implied warranty of
  *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *      GNU General Public License for more details.
  *
  *      You should have received a copy of the GNU General Public License
  *      along with this program; if not, write to the Free Software
  *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QtCore/QCoreApplication>

#include <gtk/gtk.h>
#include <glib-2.0/glib.h>
#include <QStringList>
#include <QDebug>

#define MAIN_CONF "/etc/bluetooth/main.conf"
void show_usage()
{
    printf(
		"btinputplugin [enable/disable]\n"
		"enable/disable input plugin in /etc/bluetooth/main.conf\n"
		);
}
int enable()
{
    int result=0;
    GKeyFile * file;
    GKeyFileFlags flags=GKeyFileFlags(G_KEY_FILE_KEEP_COMMENTS|G_KEY_FILE_KEEP_TRANSLATIONS);
    gchar * gcDisablePlugins=NULL;
    gchar * data=NULL;
    QStringList disablePluginsList;
    QString disablePlugins;
    file = g_key_file_new();
    if(!g_key_file_load_from_file(file,MAIN_CONF,flags,NULL))
    {
	result = 1;
	goto complete;
    }
    if(NULL == ( gcDisablePlugins = g_key_file_get_string(file,"General","DisablePlugins",NULL) ) )
    {
	result = 2;
	goto complete;
    }

    disablePlugins=gcDisablePlugins;
    g_free(gcDisablePlugins);

    disablePluginsList=disablePlugins.split(",",QString::SkipEmptyParts);
    qDebug() << disablePluginsList;

    if(!disablePluginsList.contains("input"))
	goto complete;

    disablePluginsList.removeOne("input");
    if(!disablePluginsList.isEmpty())
	disablePlugins=disablePluginsList.join(",");
    else
	disablePlugins="";

    qDebug() << disablePlugins;

    g_key_file_set_string(file,"General","DisablePlugins",disablePlugins.toLatin1());

    data = g_key_file_to_data(file,NULL,NULL);

    disablePlugins=data;
    g_free(data);

    disablePlugins.replace(" = ","=");
    disablePlugins.replace("="," = ");

    if( !g_file_set_contents(MAIN_CONF,disablePlugins.toLatin1(),-1,NULL) )
	result=3;


complete:
    g_key_file_free(file);

    return result;

}


int disable()
{
    int result=0;
    GKeyFile * file;
    GKeyFileFlags flags=GKeyFileFlags(G_KEY_FILE_KEEP_COMMENTS|G_KEY_FILE_KEEP_TRANSLATIONS);
    gchar * gcDisablePlugins=NULL;
    gchar * data=NULL;
    QStringList disablePluginsList;
    QString disablePlugins;
    file = g_key_file_new();
    if(!g_key_file_load_from_file(file,MAIN_CONF,flags,NULL))
    {
	result = 1;
	goto complete;
    }
    if(NULL != ( gcDisablePlugins = g_key_file_get_string(file,"General","DisablePlugins",NULL) ) )
    {
	disablePlugins=gcDisablePlugins;
	g_free(gcDisablePlugins);
    }

    disablePluginsList=disablePlugins.split(",",QString::SkipEmptyParts);
    qDebug() << disablePluginsList;

    if(disablePluginsList.contains("input"))
	goto complete;

    disablePluginsList.append("input");
    disablePlugins=disablePluginsList.join(",");

    qDebug() << disablePlugins;

    g_key_file_set_string(file,"General","DisablePlugins",disablePlugins.toLatin1());

    data = g_key_file_to_data(file,NULL,NULL);

    disablePlugins=data;
    g_free(data);

    disablePlugins.replace(" = ","=");
    disablePlugins.replace("="," = ");

    if( !g_file_set_contents(MAIN_CONF,disablePlugins.toLatin1(),-1,NULL) )
	result=3;


complete:
    g_key_file_free(file);

    return result;

}


int main(int argc, char *argv[])
{

    if(argc !=2)
    {
	show_usage();
	return 4;
    }
    QString action(argv[1]);
    if(action == "enable")
	return enable();
    if(action == "disable")
	return disable();

    show_usage();
    return 5;
}

