#include "FileLoggerConfig.h"

#include <QSettings>

#define CONFIG_KEY_FILE_LOGGER_IS_ENABLED           "/prefs/logging/enabled"
#define CONFIG_KEY_FILE_LOGGER_IS_RUN_ON_STARTUP    "/prefs/logging/on-startup"
#define CONFIG_KEY_FILE_LOGGER_FORMAT               "/prefs/logging/format"

FileLoggerConfig::FileLoggerConfig(QObject *parent) : QObject(parent) {/* ... */}

bool FileLoggerConfig::isEnabled() const
{
    return QSettings().value(CONFIG_KEY_FILE_LOGGER_IS_ENABLED, false).toBool();
}

bool FileLoggerConfig::isRunOnStartup() const
{
    return QSettings().value(CONFIG_KEY_FILE_LOGGER_IS_RUN_ON_STARTUP, false).toBool();
}

QString FileLoggerConfig::formatId() const
{
    return QSettings().value(CONFIG_KEY_FILE_LOGGER_FORMAT, "nmea").toString();
}

void FileLoggerConfig::setEnabled(bool isEnabled)
{
    QSettings().setValue(CONFIG_KEY_FILE_LOGGER_IS_ENABLED, isEnabled);
}

void FileLoggerConfig::setRunOnStartup(bool isRunOnStartup)
{
    QSettings().setValue(CONFIG_KEY_FILE_LOGGER_IS_RUN_ON_STARTUP, isRunOnStartup);
}

void FileLoggerConfig::setFormatId(const QString &formatId)
{
    QSettings().setValue(CONFIG_KEY_FILE_LOGGER_FORMAT, formatId);
}
