#ifndef ABSTRACTLOGGINGFORMATTER_H
#define ABSTRACTLOGGINGFORMATTER_H

#include <QObject>
#include <QByteArray>

class AbstractLoggingFormatter : public QObject
{
    Q_OBJECT

public:
    explicit AbstractLoggingFormatter(QObject *parent = 0) : QObject(parent) {}
    virtual ~AbstractLoggingFormatter() {}

    virtual QString id() const = 0;
    virtual QString friendlyName() const = 0;

signals:
    void dataReady(const QByteArray &data);
};

#endif // ABSTRACTLOGGINGFORMATTER_H
