#ifndef COLUMBUSWAYPOINTMODEL_H
#define COLUMBUSWAYPOINTMODEL_H

#include "ColumbusWaypoint.h"

#include <QSqlTableModel>
#include <QGeoPositionInfo>

QTM_USE_NAMESPACE

class ColumbusController;
class ColumbusWaypointModelPrivate;

class ColumbusWaypointModel : public QSqlTableModel
{
    Q_OBJECT

    Q_PROPERTY(QModelIndex destination READ destination WRITE setDestination NOTIFY destinationChanged)

public:
    typedef enum
    {
        Id,
        Name,
        Latitude,
        Longitude,
        Altitude,
        Distance,
        Bearing,
        ColumnCount
    } WaypointColumn;

    explicit ColumbusWaypointModel(ColumbusController *controller, QSqlDatabase db = QSqlDatabase());
            ~ColumbusWaypointModel();

    QVariant             data           (const QModelIndex &idx, int role) const;

    ColumbusWaypoint     waypoint       (const QModelIndex &index) const;

    bool                 addWaypoint    (const ColumbusWaypoint &waypoint);
    bool                 addWaypoint    (const QString &name, const QGeoCoordinate &coord);

    bool                 setWaypoint    (int row, const ColumbusWaypoint &waypoint);
    bool                 setWaypoint    (int row, const QString &name, const QGeoCoordinate &coord);

    QModelIndex          destination    () const;

signals:
    void destinationChanged(const QModelIndex &index);

public slots:
    void setDestination(const QModelIndex &index);

protected slots:
    // This is required to update distance and bearing columns.
    void onPositionUpdate(const QGeoPositionInfo &posinfo);

private:
    ColumbusWaypointModelPrivate *d;
};

#endif // COLUMBUSWAYPOINTMODEL_H
