#ifndef PLUGININTERFACE_H
#define PLUGININTERFACE_H

#include <QObject>
#include <QWidget>
#include <QtPlugin>

class PluginManager;

class ColumbusPluginInterface
{
public:
    virtual ~ColumbusPluginInterface () {};

    virtual QString id              () const = 0;
    virtual QString version         () const = 0;
    virtual QString friendlyName    () const = 0;

    virtual QWidget* control        () {return NULL;}

    virtual bool initialize         (PluginManager *manager) = 0;
};

Q_DECLARE_INTERFACE(ColumbusPluginInterface, "rx.Columbus.PluginInterface/1.0")

#endif // PLUGININTERFACE_H
