// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: LogClient-main.cpp,v 1.3 2006/07/20 02:30:55 vlg Exp $
//------------------------------------------------------------------------------
//                            LogClient-main.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2003 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed May 21 18:26:28 2003
//
//------------------------------------------------------------------------------

static const char help_msg[]=
"                                                                            \n"
" NAME:                                                                      \n"
"                                                                            \n"
"   log-client                                                               \n"
"                                                                            \n"
" DESCRIPTION:                                                               \n"
"                                                                            \n"
"   log-client is an example test program to illustrate usage of             \n"
"   assa-logd log server. It sends an arbitrary text file to the             \n"
"   log server, each line as an individual message. Then it compares         \n"
"   the original with the result. An optional pause can be introduced        \n"
"   between sending each consecutive message.                                \n"
"                                                                            \n"
"   You can also request each message to be of certain number of bytes,      \n"
"   thus disregarding the line boundaries. This option is used to test       \n"
"   class Logger_Impl handling of the messages that exceed its internal      \n"
"   static buffer. Send a big file and make sure neither client nor          \n"
"   server grow in its heap size.                                            \n"
"                                                                            \n"
" USAGE:                                                                     \n"
"                                                                            \n"
"   shell>  log-client [OPTIONS]                                             \n"
"                                                                            \n"
" OPTIONS:                                                                   \n"
"                                                                            \n"
"     --input-file NAME   - File to send to the server.                      \n"
"     --delay NUM         - Delay sending each line (in seconds).            \n"
"     --message-size NUM  - Set each message size to NUM bytes, regardless   \n"
"                           of line boundaries.                              \n"
"                                                                            \n"
" -D, --log-file NAME     - Write debug to NAME file                         \n"
" -d, --log-stdout        - Write debug to standard output                   \n"
" -z, --log-size NUM      - Maximum size debug file can reach (dfl: is 10Mb) \n"
"                                                                            \n"
" -m, --mask MASK         - Mask (default: ALL = 0x7fffffff)                 \n"
" -n, --instance NUM      - Process instance NUM (default - none)            \n"
"                                                                            \n"
" -h, --help              - Print this messag                                \n"
" -v, --version           - Print version number                            \n";
//------------------------------------------------------------------------------

#include "LogClient-main.h"
#include "LogClient.h"

int
main (int argc, char* argv[])
{
    static const char release[] = "VERSION";
    int patch_level = 0;

    LOGCLIENT->set_version (release, patch_level);
    LOGCLIENT->set_author  ("Vladislav Grinchenko");
    LOGCLIENT->set_flags   (ASSA::GenServer::RMLOG);

    LOGCLIENT->init (&argc, argv, help_msg);
 
    LOGCLIENT->init_service ();
    LOGCLIENT->process_events ();

    return LOGCLIENT->get_exit_value ();
}
