/* vim: set sw=4 ts=4 et: */
/*
 * This file is part of Live Wallpaper (livewp)
 * 
 * Copyright (C) 2010 Vlad Vasiliev
 * Copyright (C) 2010 Tanya Makova
 *       for the code
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
*/
/*******************************************************************************/
#include "livewp-settings.h"
/*******************************************************************************/
void lw_about(void){

    GtkWidget *window = NULL,
    *vbox = NULL,
    *label_about = NULL;
    window = gtk_dialog_new();
    gtk_window_set_title(GTK_WINDOW(window), _("About"));
    gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    gtk_window_set_modal(GTK_WINDOW(window), TRUE);
    vbox = gtk_vbox_new (FALSE, 5);
    label_about = gtk_label_new (_("Live Wallpaper Version 0.6.1 \n Copyright(c) 2010\n \
Tanya Makova\n Vlad Vasiliev\n \
Copyright(c) 2010 for design themes Berlin and Modern Vasya Bobrikov\n \
Copyright(c) 2010 for design theme Matrix Andrew Zhilin\n \
Translators:\n \
Finnish - Marko Vertainen\n \
Spain  - Alejandro López\n \
Russian - Tanya Makova \n \
          Vlad Vasiliev\n")); 
    gtk_box_pack_start (GTK_BOX (vbox), label_about, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   vbox, TRUE, TRUE, 0);
    gtk_widget_show (label_about);
    gtk_widget_show (vbox);
    gtk_widget_show (window);
    gtk_dialog_run(GTK_DIALOG(window));

}
/*******************************************************************************/
GtkWidget *
create_theme_selector (void){
      GtkWidget *selector;

      selector = hildon_touch_selector_new_text ();

      hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), _("Berlin"));
      hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), _("Modern"));
      hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), _("Matrix"));
      return selector;
}
/*******************************************************************************/
void
theme_button_clicked(GtkButton *button, Animation_WallpaperPrivate *priv){

    lw_theme_settings(priv, button);
}
/********************************************************************************/
void
set_button_image(GtkWidget * button, gchar *theme, gboolean enable){
    GtkWidget * image = NULL; 
    GdkPixbuf * pixbuf = NULL;
    gchar *str = NULL;
    if (enable)
        str = g_strdup_printf( "%s/%s/%s", THEME_PATH, 
                        theme, "icon.png");
    else 
        str = g_strdup_printf( "%s/%s/%s", THEME_PATH, 
                        theme, "icond.png");
    pixbuf = gdk_pixbuf_new_from_file_at_size (str, 
                                             100, 
                                             60, 
                                             NULL);
    if (str)
        g_free(str);
    if (pixbuf){
        image = gtk_image_new_from_pixbuf (pixbuf);
        g_object_unref(G_OBJECT(pixbuf));
    }

   hildon_button_set_image (HILDON_BUTTON (button), image);
}
/********************************************************************************/
GtkWidget *
create_image_button (gint view, DBusConnection *conn_sess){
    GtkWidget *button;
    GtkWidget *image;
    gchar * str;
    GdkPixbuf * pixbuf;
    
    Animation_WallpaperPrivate *priv = g_new0(Animation_WallpaperPrivate, 1);
    priv->view = view;
    priv->dbus_conn_session = conn_sess;
    read_config(priv);
    button = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                                    HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    g_object_set_data(G_OBJECT(button), "view", GINT_TO_POINTER(view));
    set_button_image(button, priv->theme, check_applet_state(view));
    g_signal_connect(button, "clicked", G_CALLBACK(theme_button_clicked), priv);
    hildon_button_set_image_position (HILDON_BUTTON (button), GTK_POS_RIGHT);
    return button;

}
/********************************************************************************/
GtkWidget *
create_themes_button (gchar *theme){

    GtkWidget *button;
    GtkWidget *selector;

    selector = create_theme_selector();
    button = hildon_picker_button_new (HILDON_SIZE_AUTO, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title (HILDON_BUTTON (button), _("Theme"));
    hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (button),
                                                       HILDON_TOUCH_SELECTOR (selector));
    if (theme) {
        if (!strcmp(theme, "Berlin")){
            hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 0);
            hildon_button_set_value(HILDON_BUTTON(button), _("Berlin"));
        }
        if (!strcmp(theme, "Modern")){
            hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 1);
            hildon_button_set_value(HILDON_BUTTON(button), _("Modern"));
        }
        if (!strcmp(theme, "Matrix")){
            hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 2);
            hildon_button_set_value(HILDON_BUTTON(button), _("Matrix"));
        }

    }
    return button;
}

/*******************************************************************************/
GtkWidget *
create_rich_animation_button (gboolean active)
{
    GtkWidget *button;
    button = hildon_check_button_new (HILDON_SIZE_AUTO);
    gtk_button_set_label (GTK_BUTTON (button), _("Rich Animation"));
    hildon_check_button_set_active(HILDON_CHECK_BUTTON(button), active);
    return button;
}
/*******************************************************************************/
GtkWidget *
create_enable_button (gboolean active)
{
    GtkWidget *button;
    button = hildon_check_button_new (HILDON_SIZE_AUTO);
    gtk_button_set_label (GTK_BUTTON (button), _("Enable"));
    hildon_check_button_set_active(HILDON_CHECK_BUTTON(button), active);
    return button;
}

/*******************************************************************************/
void
show_settings(GtkWidget *widget, Animation_WallpaperPrivate *priv){
    lw_main_settings(priv, NULL);
}
/*******************************************************************************/
void 
lw_main_settings(Animation_WallpaperPrivate *priv, gpointer data){
    gint result;
    GtkWidget *window = NULL;
    GtkWidget *theme_button1;
    GtkWidget *theme_button2;
    GtkWidget *theme_button3;
    GtkWidget *theme_button4;
    GtkWidget *hbox;

    window = gtk_dialog_new();

    gtk_window_set_title(GTK_WINDOW(window), _("Live Wallpaper Settings"));
    gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    gtk_window_set_modal(GTK_WINDOW(window), TRUE);
    /* Create Theme button */
    hbox = gtk_hbox_new(FALSE, 5);
    theme_button1 = create_image_button(0, priv->dbus_conn_session);
    gtk_box_pack_start(GTK_BOX(hbox),
                                   theme_button1, TRUE, TRUE, 5);
    theme_button2 = create_image_button(1, priv->dbus_conn_session);
    gtk_box_pack_start(GTK_BOX(hbox),
                                   theme_button2, TRUE, TRUE, 5);
    theme_button3 = create_image_button(2, priv->dbus_conn_session);
    gtk_box_pack_start(GTK_BOX(hbox),
                                   theme_button3, TRUE, TRUE, 5);
    theme_button4 = create_image_button(3, priv->dbus_conn_session);
    gtk_box_pack_start(GTK_BOX(hbox),
                                   theme_button4, TRUE, TRUE, 5);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   hbox, TRUE, TRUE, 5);

    gtk_widget_show (theme_button1);
    gtk_widget_show (theme_button2);
    gtk_widget_show (theme_button3);
    gtk_widget_show (theme_button4);
    gtk_widget_show_all (hbox);
    gtk_widget_show (window);
    gtk_dialog_add_button(GTK_DIALOG(window), _("About"), GTK_RESPONSE_NO);

    result = gtk_dialog_run(GTK_DIALOG(window));

    switch(result){
        case GTK_RESPONSE_NO:
            gtk_widget_destroy(window);
            window = NULL;
            lw_about();
        break;
    }
    if (window)
        gtk_widget_destroy(window);
}

/*******************************************************************************/
void 
lw_theme_settings(Animation_WallpaperPrivate *priv, GtkWidget *button){
    gint result;
    GtkWidget *window = NULL;
    GtkWidget *save_button;
    GtkWidget *theme_button;
    GtkWidget *enable_button;
    GtkWidget *rich_animation_button;
    gint view = priv->view;

    window = gtk_dialog_new();

    gtk_window_set_title(GTK_WINDOW(window), _("View Settings"));
    gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    gtk_window_set_modal(GTK_WINDOW(window), TRUE);
    /* Create Enable button */
    enable_button = create_enable_button(check_applet_state(view)); 
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   enable_button, TRUE, TRUE, 5);
    /* Create Theme button */
    theme_button = create_themes_button(priv->theme);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   theme_button, TRUE, TRUE, 5);
    /* Create rich animation button */  
    rich_animation_button = create_rich_animation_button(priv->rich_animation);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   rich_animation_button, TRUE, TRUE, 5);
    gtk_widget_show (enable_button);
    gtk_widget_show (theme_button);
    gtk_widget_show (rich_animation_button);
    gtk_widget_show (window);
    save_button = gtk_dialog_add_button(GTK_DIALOG(window), _("Save"), GTK_RESPONSE_YES);

    result = gtk_dialog_run(GTK_DIALOG(window));

    switch(result){
        case GTK_RESPONSE_YES:
            /* Check theme */
            if (hildon_button_get_value(HILDON_BUTTON (theme_button))){
                if (priv->theme)
                    g_free(priv->theme);
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Berlin")))
                    priv->theme = g_strdup("Berlin");
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Modern")))
                    priv->theme = g_strdup("Modern");
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Matrix")))
                    priv->theme = g_strdup("Matrix");
            }
            /* Check rich animation */
            if (hildon_check_button_get_active (HILDON_CHECK_BUTTON(rich_animation_button)))
                priv->rich_animation = TRUE;
            else
                priv->rich_animation = FALSE;
                        /* Save config */
            save_config(priv);
            /* action with applet */
            if (hildon_check_button_get_active (HILDON_CHECK_BUTTON(enable_button))){
                    if (!check_applet_state(view)){
                        start_applet(view);
                    }else {
                        send_dbus_signal (priv,
                              LIVEWP_SIGNAL_INTERFACE,
                              LIVEWP_SIGNAL_PATH,
                              LIVEWP_RELOAD_CONFIG);
                    }
            }else
                    if (check_applet_state(view))
                        stop_applet(view);

            set_button_image(button, priv->theme, check_applet_state(view));
            break;
        default:
        case GTK_RESPONSE_OK:
        break;
        case GTK_RESPONSE_NO:
            gtk_widget_destroy(window);
            window = NULL;
            lw_about();
        break;
    }
    if (window)
        gtk_widget_destroy(window);
}
/*******************************************************************************/
gboolean
check_applet_state(gint number){

    HDConfigFile *config_file = NULL;
    GKeyFile *gkey_file = NULL;
    gchar *str = NULL;
    gboolean result = FALSE;
    if (number > 3 || number < 0)
        return FALSE;

    str = g_strdup_printf("livewp-home-widget.desktop-%i",number);
    config_file = hd_config_file_new(NULL, "/home/user/.config/hildon-desktop/", "home.plugins");
    
    gkey_file = hd_config_file_load_file(config_file, FALSE);
    if (gkey_file && str){
        result = g_key_file_has_group(gkey_file, str);
        g_free(str);
    }
    return result;
#if 0
    FILE    *file_in = NULL;
    gchar buffer[2048];

    file_in = fopen("/home/user/.config/hildon-desktop/home.plugins","r");
    if (file_in){

        fprintf(stderr,"Check applet state\n");
        while (!feof(file_in)) {
                memset(buffer, 0, sizeof(buffer));
                fgets(buffer, sizeof(buffer) - 1, file_in);
                if (!strcmp(buffer, 
                            "X-Desktop-File=/usr/share/applications/hildon-home/livewp-home-widget.desktop\n")){
                    result = TRUE;
                    break;
                }
       }
        fclose(file_in);
    }
#endif
}
/*******************************************************************************/
void
start_applet(gint number){

    HDConfigFile *config_file = NULL;
    GKeyFile *gkey_file = NULL;
    gchar *str = NULL;

    if (number > 3 || number < 0)
        return;
    str = g_strdup_printf("livewp-home-widget.desktop-%i",number);
    config_file = hd_config_file_new(NULL, "/home/user/.config/hildon-desktop/", "home.plugins");
    
    gkey_file = hd_config_file_load_file(config_file, FALSE);
    if (gkey_file){
        g_key_file_set_string (gkey_file, str, "X-Desktop-File", "/usr/share/applications/hildon-home/livewp-home-widget.desktop");
        hd_config_file_save_file( config_file, gkey_file);
        g_key_file_free(gkey_file);
    }else
        fprintf(stderr, "Problem with config file");
    if (str)
        g_free(str);
    g_object_unref(config_file);
}
/*******************************************************************************/
void
stop_applet(gint number){
    HDConfigFile *config_file = NULL;
    GKeyFile *gkey_file = NULL;
    gchar *str = NULL;

    if (number > 3 || number < 0)
        return;
    str = g_strdup_printf("livewp-home-widget.desktop-%i",number);
    config_file = hd_config_file_new(NULL, "/home/user/.config/hildon-desktop/", "home.plugins");
    
    gkey_file = hd_config_file_load_file(config_file, FALSE);
    if (gkey_file){
         g_key_file_remove_group(gkey_file, str, NULL);  
        hd_config_file_save_file( config_file, gkey_file);
        g_key_file_free(gkey_file);
    }else
        fprintf(stderr, "Problem with config file");
    if (str)
        g_free(str);
    g_object_unref(config_file);

#if 0    
    FILE    *file_in;
    FILE    *file_out;
    gchar buffer[2048];
    gchar * str = NULL;

    file_in = fopen("/home/user/.config/hildon-desktop/home.plugins","r");
    file_out = fopen("/tmp/livewallpaper.plugins","w");
    if (file_in && file_out){
        while (!feof(file_in)) {
            memset(buffer, 0, sizeof(buffer));
            fgets(buffer, sizeof(buffer) - 1, file_in);
            str = g_strdup_printf("[livewp-home-widget.desktop-%i]\n", number);
            if (strcmp(buffer, str) &&
                strcmp(buffer, "X-Desktop-File=/usr/share/applications/hildon-home/livewp-home-widget.desktop\n"))
                fputs(buffer, file_out);
        }
        if (str){
            g_free(str);
        }
        fclose(file_out);
        fclose(file_in);
        file_in = fopen("/tmp/livewallpaper.plugins","r");
        file_out = fopen("/home/user/.config/hildon-desktop/home.plugins","w");
        if (file_in && file_out){
            while (!feof(file_in)){
                memset(buffer, 0, sizeof(buffer));
                fgets(buffer, sizeof(buffer) - 1, file_in);
                fputs(buffer, file_out);
            }
            fclose(file_out);
            fclose(file_in);
            unlink ("/tmp/livewallpaper.plugins");
        }
    }
#endif
}
