
// please remerge this directly back into the library at the first opportunity
// it has the same api as the original liqaccel but allows for a flag to determine if the smoothing is in effect


// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>


//#####################################################################
//#####################################################################
//##################################################################### liqaccel.c contents need remerging to allow enable/disable smoothing
//#####################################################################
//#####################################################################

static int ocnt=0;
static int oax=0;
static int oay=0;
static int oaz=0;
	
static const char *accel_filename = "/sys/class/i2c-adapter/i2c-3/3-001d/coord";

int liqaccel_read(int *ax,int *ay,int *az)
{
	FILE *fd;
	int rs;
	fd = fopen(accel_filename, "r");
	if(fd==NULL){ liqapp_log("liqaccel, cannot open for reading"); return -1;}	
	rs=fscanf((FILE*) fd,"%i %i %i",ax,ay,az);	
	fclose(fd);	
	if(rs != 3){ liqapp_log("liqaccel, cannot read information"); return -2;}
	
	char *prefsmooth = liqapp_pref_getvalue_def("liqaccel_usesmoothing","yes");
	
	if( ocnt>0 && (prefsmooth && *prefsmooth == 'y') )
	{
		int bx=*ax;
		int by=*ay;
		int bz=*az;
		*ax=oax+(bx-oax)*0.1;
		*ay=oay+(by-oay)*0.1;
		*az=oaz+(bz-oaz)*0.1;
	}
	oax=*ax;
	oay=*ay;
	oaz=*az;
	ocnt++;
	return 0;
}
