/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0

Item {
    id: toolbar

    property alias button1Label: button1.text
    property alias button2Label: button2.text

    signal button1Clicked
    signal button2Clicked

    Rectangle {
        color:"#7373b1"
        width: parent.width
        height: parent.height + 14

        radius: 4
    }

    Button {
        id:button1
        anchors.left: parent.left
        anchors.leftMargin: 5
        y: 5
        width: 140
        height: 42
        onClicked: toolbar.button1Clicked();
    }

    Button {
        id:button2
        anchors.right: parent.right
        anchors.rightMargin: 5
        y: 5
        width: 140
        height: 42
        onClicked: toolbar.button2Clicked();
    }

}
