/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0
import "Settings.js" as Settings
import "Themes.js" as Themes

Item{

    id:optionsscreen

    anchors.verticalCenter: parent.verticalCenter
    width: parent.width; height: parent.height;
    x:-(parent.width * 1.5)

    signal close

    Loader {
        id: theme_manager
        property alias theme: theme_manager.item
        source: Themes.default_theme()
    }

    Connections {
        target: optionsscreen.parent

        onDialogClose: {
            optionsscreen.state = "close";
            optionsscreen.destroy(600);
        }
    }

    Rectangle {
        id: rectangle1
        anchors.fill: parent; anchors.bottomMargin: 16
        visible: true
        opacity:0.9

        Component {
                id: listDelegate
                 Rectangle {
                     height:60

                     Rectangle {
                                         width:rectangle1.width;
                                         y:0;
                                         x:0
                                         height:1
                                         border.color: "#b57e8f"
                     }

                     Text {
                         id: text1
                         text:name
                         font.pixelSize: 21
                         font.family: "Nokia Sans"
                         x:20
                         anchors.verticalCenter: parent.verticalCenter

                     }
                        Switch {
                            id: switch_me
                            x:rectangle1.width-220
                            onSwitched:{
                                listModel.setProperty(index, "selected", switchedOn);
                            }
                            switchedOn: selected
                            anchors.verticalCenter: parent.verticalCenter
                        }

                 }

            }

        ListModel {
                 id: listModel
                 Component.onCompleted: {
                     Settings.restore(listModel);
                     var cdx = Settings.chedoxoay();
                     ROOT.initScreenOrientation(cdx);
                 }
         }

        ListView {
              id: listView
              anchors.fill: parent;anchors.topMargin: 45;anchors.leftMargin: 0;
              model: listModel
              delegate: listDelegate
              focus: true
              ScrollBar{}
        }

    }

    Rectangle {
        width : optionsscreen.width
        height: 45
        color:"white"
        opacity: 0.5
    }

    Text {
        id: title

        anchors { horizontalCenter: optionsscreen.horizontalCenter; top: optionsscreen.top; topMargin: 10 }
        font.pixelSize: 22
        color: "black"
        text: "Lựa Chọn"
        smooth: true
        font.bold: true
    }

    ToolBar {
        id: toolBar; height: 42;
        y: parent.height-52
        width: parent.width;
        button1Label: "Đồng Ý"
        button2Label: "Hủy Bỏ"
        onButton1Clicked:
        {
            Settings.save(listModel)
            optionsscreen.close();

            var cdx = Settings.chedoxoay();
            ROOT.initScreenOrientation(cdx);
        }
        onButton2Clicked: {
            Settings.restore(listModel)
            optionsscreen.close();
        }
    }

    states: [
        State {
            name: "show"
            AnchorChanges { target: optionsscreen; anchors.right: parent.right }
        },
        State {
            name: "close"
            AnchorChanges { target: optionsscreen; anchors.right: parent.left }
        }
    ]

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 300 }
    }
}
