/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0

import "Themes.js" as Themes
import "main.js" as Script

Item{
    id: amdatetime
    state: "switch_me"
    
    anchors.verticalCenter: parent.verticalCenter
    width: parent.width; height: parent.height;
    x:(parent.width * 1.5)
    
    Loader {
        id: theme_manager
        property alias theme: theme_manager.item
        source: Themes.default_theme()
        }
    
    signal toolbar
    signal updatedate(int day, int month, int year)
    
    Rectangle {
        id: rectangle1
        x: 0
        y: -16
        anchors.centerIn: parent
        width:460
        height: 234
        color: "#19262b"
        radius: 8
        border.color: "#b57e8f"
        visible: true
        opacity:0.9
        
        Button {
            id: button2
            anchors.right: parent.right; anchors.rightMargin: 145; y: 185; width: 100; height: 40
            anchors.horizontalCenter: parent.horizontalCenter
            
            text: "OK"
            onClicked: {
                var lday = lunarday_pathview.currentIndex+1;
                var lmonth=lunarmonth_pathview.currentIndex+1;
                var lyear=lunaryear_pathview.currentIndex+1900;
                
                var lnhuan=0;
                
                var thangnhuan = -1;
                
                for (var l=0;l<12;l++)
                if (lunarmonth_model.get(l).nhuan){
                    thangnhuan = l;
                    }
                
                if(lunarmonth_model.get(lunarmonth_pathview.currentIndex).nhuan){
                    lnhuan=1;
                    lmonth=lmonth-1;
                    }
                
                if (thangnhuan!=-1 && lunarmonth_pathview.currentIndex> thangnhuan)
                lmonth-=1;
                
                var finalSolarDay = Script.convertLunar2Solar(lday,lmonth,lyear,lnhuan,7);
                
                amdatetime.state="close";
                amdatetime.toolbar();
                amdatetime.updatedate(finalSolarDay[0], finalSolarDay[1], finalSolarDay[2])
                
                }
            }
        
        Button {
            id: button3
            x: 413
            y: 6
            width: 39
            height: 40
            text: "X"
            anchors.rightMargin: 56
            onClicked: {
                amdatetime.state="close"
                amdatetime.toolbar()
                }
            }
        
        Rectangle {
            id: rec22
            x: 23
            y: 89
            width: 415
            height: 56
            radius: 9
            gradient: Gradient {
                GradientStop {
                    position: 0
                    color: "#ffffff"
                    }
                
                GradientStop {
                    position: 0.1
                    color: "#7c6969"
                    }
                }
            border.color: "#b57e8f"
            
            Rectangle {
                id:lmk
                x: 207
                y: -39
                width: 198; height: 129
                gradient: Gradient {
                    GradientStop {
                        position: 0.89
                        color: "#148ebe"
                        }
                    
                    GradientStop {
                        position: 0.01
                        color: "#19262b"
                        }
                    
                    GradientStop {
                        position: 0.13
                        color: "#6eb3d5"
                        }
                    
                    GradientStop {
                        position: 1
                        color: "#19262b"
                        }
                    }
                }
            
            states: [
                State {
                    name: "switch_to_day";
                    PropertyChanges { target:lmk;x:10;width:60;}
                    PropertyChanges { target:lunaryear_pathview;pathItemCount:1;}
                    PropertyChanges { target:lunarmonth_pathview;pathItemCount:1;}
                    PropertyChanges { target:lunarday_pathview;pathItemCount:3;}
                    PropertyChanges { target:lunarday_mousearea;visible:false;}
                    PropertyChanges { target:lunaryear_mousearea;visible:true;}
                    PropertyChanges { target:lunarmonth_mousearea;visible:true;}
                    },
                State {
                    name: "switch_to_year";
                    PropertyChanges { target:lmk;x:207;width:198;}
                    PropertyChanges { target:lunarday_pathview;pathItemCount:1;}
                    PropertyChanges { target:lunarmonth_pathview;pathItemCount:1;}
                    PropertyChanges { target:lunaryear_pathview;pathItemCount:3;}
                    PropertyChanges { target:lunarday_mousearea;visible:true;}
                    PropertyChanges { target:lunaryear_mousearea;visible:false;}
                    PropertyChanges { target:lunarmonth_mousearea;visible:true;}
                    },
                State {
                    name: "switch_to_month";
                    PropertyChanges { target:lmk;x:60;width:150;}
                    PropertyChanges { target:lunarday_pathview;pathItemCount:1;}
                    PropertyChanges { target:lunaryear_pathview;pathItemCount:1;}
                    PropertyChanges { target:lunarmonth_pathview;pathItemCount:3;}
                    PropertyChanges { target:lunarday_mousearea;visible:true;}
                    PropertyChanges { target:lunaryear_mousearea;visible:true;}
                    PropertyChanges { target:lunarmonth_mousearea;visible:false;}
                    }]
            
            /**LUNAR YEAR**/
            Rectangle {
                id:lunaryear_rec
                state: "switch_to_year"
                x: 217
                y: -39
                width: 178; height: 129
                color:"transparent"
                
                property int index: 0
                onIndexChanged: lunaryear_pathview.currentIndex = lunaryear_rec.index
                
                Component {
                    id: lunaryear_delegate
                    Column {
                        id: wrapper
                        Text {
                            id: nameText
                            text: name
                            font.pointSize: 16
                            width: lunaryear_rec.width
                            color: PathView.isCurrentItem ? "#FFFFFF" : "grey"
                            verticalAlignment:Text.AlignLeft
                            font.bold: true
                        }
                    }
                }

                PathView {
                    id:lunaryear_pathview
                    anchors.fill: parent
                    model: lunaryear_model
                    delegate: lunaryear_delegate
                    pathItemCount: 3
                    clip: true
                    preferredHighlightBegin: 0.5
                    preferredHighlightEnd: 0.5
                    highlightRangeMode: PathView.StrictlyEnforceRange
                    focus: true
                    path: Path {
                        startX: 90
                        startY: 0
                        PathLine {x: 90; y: lunaryear_rec.height}
                        }
                    
                    onMovementEnded: {
                        Script.getYearInfo(lunaryear_pathview.currentIndex+1900);
                        lunarmonth_model.change(lunaryear_pathview.currentIndex+1900, lunarmonth_pathview.currentIndex+1);
                        }
                    }
                MouseArea {
                    id:lunaryear_mousearea
                    anchors.fill: parent
                    onClicked: {
                        rec22.state="switch_to_year"
                        }
                    }
                }
            
            ListModel {
                id:lunaryear_model

                function init(){
                    for(var i=1900;i<2099;i++){
                        var lunarYear = Script.getYearCanChi(i)
                        append({name:i+" ("+lunarYear+")"})
                        }
                    }
                
                function change(YYYY){
                    lunaryear_pathview.currentIndex=-1;
                    lunaryear_pathview.currentIndex = YYYY - 1900
                    }
                }
            /***/
            
            /**LUNAR DAY*/
            Rectangle{
                state:"switch_to_day"
                id:lunarday_rec
                x: -20
                y: -39
                width: 80; height: 129
                color:"transparent"
                
                property int index: 0
                onIndexChanged: lunarday_pathview.currentIndex = lunarday_rec.index
                
                Component {
                    id: lunarday_delegate
                    Column {
                        id: wrapper
                        
                        Text {
                            id: nameText
                            text: name
                            font.pointSize: 18
                            width: lunarday_rec.width
                            color: PathView.isCurrentItem ? "#FFFFFF" : "grey"
                            verticalAlignment:Text.AlignVCenter
                            font.bold: true
                            }
                        
                        }
                    }
                
                PathView {
                    id:lunarday_pathview
                    anchors.fill: parent
                    model: lunarday_model
                    delegate: lunarday_delegate
                    pathItemCount: 1
                    clip: true
                    preferredHighlightBegin: 0.5
                    preferredHighlightEnd: 0.5
                    highlightRangeMode: PathView.StrictlyEnforceRange
                    focus: true
                    path: Path {
                        startX: 90
                        startY: 0
                        PathLine {x: 90; y: lunarday_rec.height}
                        }
                    }
                
                MouseArea {
                    id:lunarday_mousearea
                    anchors.fill: parent
                    onClicked: {
                        rec22.state="switch_to_day"
                        }
                    }
                
                }
            
            ListModel {
                id:lunarday_model

                function init(){
                    for(var i=1;i<=30;i++)
                    lunarday_model.append({name:i})
                    }
                
                function change(MM,DD){
                    
                    while(lunarday_model.count>0){
                        lunarday_model.remove(lunarday_model.count-1)
                        }
                    
                    
                    var daystotal = Script.RMM[MM-1];
                    
                    if(lunarmonth_model.get(MM-1).nhuan){
                        for (var i=1;i<=Script.LML;i++)
                        lunarday_model.append({name:i})
                    }else{
                        for (var i=1;i<=daystotal;i++)
                        lunarday_model.append({name:i})
                        }

                    lunarday_pathview.currentIndex=-1;
                    lunarday_pathview.currentIndex= DD-1;
                    
                    }
                }
            
            /***/


            /**LUNAR MONTH*/
            Rectangle{
                state:"switch_to_month"
                id:lunarmonth_rec
                x: 60
                y: -39
                width: 150; height: 129
                color:"transparent"
                
                property int index: 0
                onIndexChanged: lunarmonth_pathview.currentIndex = lunarmonth_rec.index
                
                Component {
                    id: lunarmonth_delegate
                    Column {
                        id: wrapper
                        
                        Text {
                            id: nameText
                            text: name
                            font.pointSize: 16
                            width: lunarmonth_rec.width
                            color: PathView.isCurrentItem ? "#FFFFFF" : "grey"
                            verticalAlignment:Text.AlignVCenter
                            font.bold: true
                            }
                        
                        }
                    }
                
                PathView {
                    id:lunarmonth_pathview
                    anchors.fill: parent
                    model: lunarmonth_model
                    delegate: lunarmonth_delegate
                    pathItemCount: 1
                    clip: true
                    preferredHighlightBegin: 0.5
                    preferredHighlightEnd: 0.5
                    highlightRangeMode: PathView.StrictlyEnforceRange
                    focus: true
                    path: Path {
                        startX: 90
                        startY: 0
                        PathLine {x: 90; y: lunarmonth_rec.height}
                        }
                    onMovementEnded: {
                        lunarday_model.change(lunarmonth_pathview.currentIndex+1,lunarday_pathview.currentIndex+1);
                        }
                    }
                
                MouseArea {
                    id:lunarmonth_mousearea
                    anchors.fill: parent
                    onClicked: {
                        rec22.state="switch_to_month"
                        }
                    }
                
                }
            
            ListModel {
                id:lunarmonth_model
                
                Component.onCompleted: {
                    
                    }
                
                function change(YYYY, MM){
                    while(lunarmonth_model.count>0){
                        lunarmonth_model.remove(lunarmonth_model.count-1)
                        }
                    readd(YYYY, MM)
                    
                    lunarday_model.change(lunarmonth_pathview.currentIndex+1,lunarday_pathview.currentIndex+1);
                    }

                function readd(YYYY, MM){
                    var yTest = YYYY;
                    var preFix = "Tháng ";
                    var a=Script.leapMonth(yTest)
                    var t=0;
                    if(a){ // nam nhuan
                              for(var i=0;i<=12;i++){
                            var l=Script.getYearInfo(yTest)[i].month
                            if (t==l)
                            lunarmonth_model.append({name:preFix+l+" (N)", nhuan:true})
                            else
                            lunarmonth_model.append({name:preFix+l, nhuan:false})
                            t=l
                            }
                              
                              }else
                    {
                        for(var i=1;i<=12;i++)
                        lunarmonth_model.append({name:preFix+i, nhuan:false})
                        }
                    
                    lunarmonth_pathview.currentIndex=-1;
                    lunarmonth_pathview.currentIndex = MM-1;
                    
                    }
                }
            
            /***/
            }
        
        }
    
    Component.onCompleted: {
        reset();
        }
    
    states: [
        State {
            name: "show"
            AnchorChanges { target: amdatetime; anchors.right: parent.right }
            },
        State {
            name: "close"
            AnchorChanges { target: amdatetime; anchors.right: parent.left }
            }
        ]
    
    function reset(){
        var acs = Script.getYearInfo(Script.curYear)
        var a=Script.getLunarDate(Script.curDay,Script.curMonth,Script.curYear)
        var finalmonth=a.month;
        if (a.leap)
        finalmonth+=1;
        else{
            var aaa=Script.leapMonth(Script.curYear)
            var t=-1;
            
            if (aaa){
                for (var i=0;i<=12;i++){
                    var l=acs[i].month
                    if (t==l && a.leap===0){
                        if (a.month>i){
                            finalmonth = finalmonth+1;
                            break;
                            }
                        }
                    t=l
                    }
                
                }
            }
        
        lunaryear_model.init()
        lunarday_model.init()
        lunaryear_model.change(a.year)
        lunarmonth_model.change(a.year, finalmonth)
        lunarday_model.change(finalmonth,a.day)
        
        }
    
    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 300 }
        }
    }
