/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.1

Item {
    id: container

    signal clicked
    
    property string text
    
    Rectangle {
        anchors.fill: parent
        y:parent.y
        width:parent.width
        height:parent.height
        
        radius: 4
        border.color: "grey"
        
        Text {
            id: button1
            color: "#000000"
            anchors.centerIn: parent; font.bold: true
            text: container.text; style: Text.Raised; styleColor: "black"
            font.pixelSize: 22
            font.family: "Tahoma"
            }
        
        MouseArea {
            id: mouseRegion
            anchors.fill: parent
            onClicked: { container.clicked(); }
            
            onPressed: {
                parent.color = "blue"
                }
            
            onReleased: {
                parent.color = "white"
                }
            }
        }
    
    }
