import gtk, pygtk, os,sys,time,math,hildon,hildondesktop,dbus,gobject
from dbus.mainloop.glib import DBusGMainLoop
lfocus_pid=0
keyboard_stat=0
def led_on(event):
	os.popen("/usr/share/lfocus/v4l2-ctl -c torch_intensity=1")
def led_off(event):
	os.popen("/usr/share/lfocus/v4l2-ctl -c torch_intensity=0")
def rled_on(event):
	os.popen("/usr/share/lfocus/v4l2-ctl -c indicator_intensity=3")
def rled_off(event):
	os.popen("/usr/share/lfocus/v4l2-ctl -c indicator_intensity=0")
class lfocusplug(hildondesktop.StatusMenuItem):
	def __init__(self):
		hildondesktop.StatusMenuItem.__init__(self)
		dbus_loop = DBusGMainLoop()
		self.bus = dbus.SystemBus(mainloop=dbus_loop)
		self.shutter_button_obj = self.bus.get_object("org.freedesktop.Hal","/org/freedesktop/Hal/devices/platform_cam_shutter")
		self.shutter_button_iface = dbus.Interface(self.shutter_button_obj, "org.freedesktop.Hal.Device")
		self.bus.add_signal_receiver(	self.shutter_operaion, 
						signal_name=None, 
						dbus_interface= "org.freedesktop.Hal.Device", 
						bus_name="org.freedesktop.Hal", 
						path="/org/freedesktop/Hal/devices/platform_cam_shutter")
		
		#icon_theme = gtk.icon_theme_get_default()
		#image = icon_theme.load_icon("lfocus-22", 22, gtk.ICON_LOOKUP_NO_SVG)
		#self.set_status_area_icon(image)
		button1 = gtk.Button()
		button1.connect("clicked",self.lfocus_menu)
		button2 = gtk.Button()
		button2.connect("clicked",self.changer)
		image1=gtk.image_new_from_icon_name("lfocus-64", 50)
		container=gtk.Table(1,2,True)
		button1.add(image1)
		self.image2=gtk.image_new_from_icon_name("keyoff", 50)
		button2.add(self.image2)
		container2=gtk.Table(1,2,False)
		container2.attach(button1,0,1,0,1)
		container2.attach(button2,1,2,0,1)
		self.add(container2)
		self.hide_all()
		
	def lfocus_menu(self,widget,data=None):
		self.dialog1=gtk.Dialog("Focus")
		self.dialog1.set_size_request(800,50)
		table = gtk.Table(3, 1, False)
		self.dialog1.vbox.add(table)
		button2 = gtk.Button(".......")
		button2.connect("clicked", self.lfocus_leds)
		image3=gtk.image_new_from_icon_name("general_clock", 50)
		button6 = gtk.Button()
		button6.connect("clicked", self.show_diag)
		button6.add(image3)
		table.attach(button6, 1, 2, 0, 1)
		table.attach(button2, 2, 3, 0, 1)
		props = gtk.Adjustment(value=0,lower=0,upper=1023,step_incr=32,page_incr=32);
		self.sld = gtk.HScale(props)
		self.sld.set_digits(0)
		self.sld.set_value(int(os.popen("/usr/share/lfocus/v4l2-ctl -C focus_absolute|awk '{print $2}'").read()))
		self.sld.set_size_request(680,80)
		self.sld.set_draw_value(False)
		self.sld.connect('value-changed', self.set_focus)
		table.attach(self.sld, 0, 1, 0, 1)
		self.dialog1.show_all()
	def lfocus_leds(self,widget,data=None):
		self.dialog2=gtk.Dialog("LEDs")
		self.dialog2.set_size_request(800,50)
		table=gtk.Table(1,4,True)
		button3 = gtk.Button("LED on")
		button3.connect("clicked", led_on)
		table.attach(button3,0,1,0,1)
		button4=gtk.Button("LED off")
		button4.connect("clicked", led_off)
		table.attach(button4,1,2,0,1)
		button3 = gtk.Button("R.LED on")
		button3.connect("clicked", rled_on)
		table.attach(button3,2,3,0,1)
		button4=gtk.Button("R.LED off")
		button4.connect("clicked", rled_off)
		table.attach(button4,3,4,0,1)
		self.dialog2.vbox.add(table)
		self.dialog2.show_all()
	def show_diag(self,*args):
		def stopwatch(a,b,*args):
			self.dialog3.hide_all()
			self.dialog1.hide_all()
			def start_capture():
				os.popen("sudo lfocus start_capture &")
			banner = hildon.hildon_banner_show_information(self.dialog3, "lfocus-64",   "capturing in "+str(b)+" seconds") 
			self.maintimer = gobject.timeout_add(1000*b,start_capture)
							
		global diag_is_up
		diag_is_up=1		
		self.dialog3=gtk.Dialog("Stopwatch")
		self.dialog3.connect("destroy", self.dialog3.hide_all)
		self.dialog3.set_size_request(800,50)
		table = gtk.Table(1, 5, True)
		button0=gtk.Button("0s")
		button5=gtk.Button("5s")
		button10=gtk.Button("10s")
		button15=gtk.Button("15s")
		button20=gtk.Button("20s")

		button0.connect("clicked", stopwatch,.01)
		button5.connect("clicked", stopwatch,5)
		button10.connect("clicked", stopwatch,10)
		button15.connect("clicked", stopwatch,15)
		button20.connect("clicked", stopwatch,20)

		table.attach(button0, 4, 5, 0, 1)
		table.attach(button5, 3, 4, 0, 1)
		table.attach(button10, 2,3, 0, 1)
		table.attach(button15, 1, 2, 0, 1)
		table.attach(button20, 0, 1, 0, 1)
		self.dialog3.vbox.add(table)
		self.dialog3.show_all()

	def stop_autofocus(self,a,b):
		#os.popen("osso-xterm");
		self.focus_button_iface.SetPropertyBoolean("button.state.value",False)
		self.focus_button_iface.SetPropertyBoolean("button.state.value",False)
		self.focus_button_iface.SetPropertyBoolean("button.state.value",False)

	def shutter_operaion(self,a,b):
		global keyboard_stat		
		if self.shutter_button_iface.GetProperty("button.state.value"):
			os.popen("sudo lfocus stop_stop_focus &")
			if keyboard_stat==1:
				os.popen("sudo lfocus stop &")
				os.popen("setxkbmap")
				os.popen("maemo-xinput-sounds &")
				self.image2.set_from_icon_name("keyoff",50)
				keyboard_stat=0
			self.hide_all()
			self.dialog1.hide_all()
			self.dialog2.hide_all()
		else :

			self.show_all()

	def app_quit(widget, data=None):
   		gtk.main_quit()
	def set_focus(self,index):
  		os.popen("/usr/share/lfocus/v4l2-ctl -c focus_absolute="+str(math.floor(self.sld.get_value())).replace(".0",""))
	def changer(self,*args):
		global keyboard_stat
		global lfocus_pid
		if keyboard_stat==0:
			os.popen("sudo lfocus start_stop_focus &")
			os.popen("xkbcomp /usr/share/lfocus/nozoom.xkb :0 >/dev/null 2>&1")
			os.popen("killall maemo-xinput-sounds")
			os.popen("sudo lfocus start &")
			self.image2.set_from_icon_name("keyon",50)
			keyboard_stat=1
		else :
			os.popen("sudo lfocus stop_stop_focus &")
			os.popen("sudo lfocus stop &")
			os.popen("setxkbmap")
			os.popen("maemo-xinput-sounds &")
			self.image2.set_from_icon_name("keyoff",50)
			keyboard_stat=0
		
hd_plugin_type = lfocusplug
if __name__ == "__main__":
	import gobject
	gobject.type_register(hd_plugin_type)
	obj = gobject.new(hd_plugin_type, plugin_id="Live_Focus")
	obj.show_all()
	gtk.main()
