using Gst;
 
public class KnotsPlayerBackend
{
	private MainLoop loop = new MainLoop (null, false);
	private dynamic Element playbin;
	public static int MPlayer = 0;
	public static int GStreamer = 1;
	private int player_type;
	private Pid? player_pid;
	private GLib.IOChannel io;
	private Knots knots;
	private string xid;
	private GLib.TimeVal last_blank;
	private bool playing;
	private int buffer_seconds;
	
	public KnotsPlayerBackend(Knots knots, int player_type)
	{
		this.knots = knots;
		this.player_type = player_type;
	}
	
	private bool bus_callback (Gst.Bus bus, Gst.Message message)
	{
		switch (message.type)
		{
			case MessageType.ERROR:
			    stop();
			    break;
			case MessageType.EOS:
			    stop();
			    break;
			case MessageType.STREAM_STATUS:
				if (buffer_seconds != 0)
				{
					var sink = message.src;
					sink.set_property("buffer-duration", buffer_seconds);
					buffer_seconds = 0;
				}
			    break;
			case MessageType.STATE_CHANGED:
			    break;
			case MessageType.TAG:
			    break;
			case MessageType.BUFFERING:
				int percent = 0;
				message.parse_buffering(out percent);
				get_knots().get_player().show_cache_status(percent);
			     break;
			default:
				if (message.structure.get_name() == "prepare-xwindow-id")
				{
					var sink = message.src;
					((XOverlay)sink).set_xwindow_id (xid.to_ulong());
				}
			    break;
		}
		return true;
	}
	
	public Knots get_knots()
	{
		return this.knots;
	}
 
	public void play (string address, string xid, int buffer_seconds, bool screen_blanking)
	{
		this.playing = true;
		this.xid = xid;
		this.buffer_seconds = buffer_seconds;
		if (player_type == MPlayer)
		{
			int stdin;
			int cache = buffer_seconds * 64;
			string[] params = null;
			if (get_knots().get_settings().get_value("mplayer_command") == null)
				params = {"/usr/bin/mplayer", "-ao", "pulse", "-nofs", "-quiet", "-vo", "xv:ck-method=auto", "-dr", "-include", "~/.mplayer/knots"};
			else
			{
				params = get_knots().get_settings().get_value("mplayer_command").split(" ");
			}
			params += "-cache";
			params += cache.to_string();
			params += "-wid";
			params += xid;
			params += address;
			try
			{
				Process.spawn_async_with_pipes (null, params, null, SpawnFlags.DO_NOT_REAP_CHILD | SpawnFlags.LEAVE_DESCRIPTORS_OPEN | SpawnFlags.STDOUT_TO_DEV_NULL | SpawnFlags.STDERR_TO_DEV_NULL, null, out player_pid, out stdin, null, null);
				GLib.ChildWatch.add(player_pid, player_stopped);
				io = new GLib.IOChannel.unix_new(stdin);
				io.init();
			}
			catch (GLib.SpawnError e)
			{
				this.stop();
			}
		}
		else
		if (player_type == GStreamer)
		{
			playbin = ElementFactory.make ("playbin2", "video");
			playbin.uri = address;
			playbin.force_aspect = true;
			Bus bus = playbin.get_bus ();
			bus.add_watch (bus_callback);
			playbin.set_state(State.PLAYING);
			if (screen_blanking)
			{
				get_knots().disable_blanking();
				GLib.Timeout.add(2000, disable_screen_blanking);		
			}
			loop.run();		
		}
		else
		{
			stop();
		}
	}
	
	private bool disable_screen_blanking()
	{
		TimeVal time = TimeVal();
		time.get_current_time();
		if (time.tv_sec - last_blank.tv_sec >= 50)
		{	
			get_knots().disable_blanking();
			last_blank.get_current_time();
		}
		return this.playing;
	}
    
	public void player_key(char key)
	{
		if (this.player_type == MPlayer && io != null)
		{
			char[] c = {key};
			try
			{
				try
				{
					size_t written;
					io.write_chars(c, out written);
					io.flush();
				}
				catch (GLib.IOChannelError e)
				{
					GLib.warning ("Error: %s", e.message);
				}
			}
			catch (GLib.ConvertError ee)
			{
				GLib.warning ("Error: %s", ee.message);
			}
		}
	}
	
	public int player()
	{
		return this.player_type;
	}
	
	public void stop()
	{
		if (player_type == MPlayer)
		{
			player_key('q');
			GLib.Process.close_pid(player_pid);
			try
			{
				string output;
				GLib.Process.spawn_command_line_sync("killall -9 mplayer", out output);
			}
			catch (GLib.SpawnError se)
			{
			}
			try
			{
				if (io != null)
					io.shutdown(false);
			}
			catch (GLib.IOChannelError ce)
			{
				
			}
			io = null;
		}
		else
		if (player_type == GStreamer)
		{
			get_knots().get_player().stop();
			if (playbin != null)
				playbin.set_state (State.NULL);
			loop.quit ();
		}
		this.playing = false;
	}
	
	public void player_stopped(GLib.Pid pid, int status)
	{
		GLib.Process.close_pid(pid);
		get_knots().get_player().stop();
	}
}

