/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *															                                  	      *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>

class PageViewWidget;
class ToolBarWidget; 
class ContentsWidget;
class QPushButton;
class QKeyEvent;

class MainWindow: public QMainWindow
{
Q_OBJECT

public:
    MainWindow(QWidget *parent = 0, Qt::WindowFlags flags = 0);
    virtual ~MainWindow();

public:
    // these calls are made when the toolbar gets clicked
    void doFullScreenOn();
    void doZoomIn();
    void doZoomOut();
    void doOpenTableOfContents();
    void doOpenFile();

public slots:
    void minimizeApplication();
    void pickedContent();
    void doFullScreenOff();
    void doNextPage();
    void doPrevPage();

    void showFullScreenControls();
    void hideFullScreenControls();

protected:
    void keyPressEvent(QKeyEvent* event);
      

private:
    void openFile( const QString& fileName );
    
    void grabZoomKeys(bool grab = true );

private:
    PageViewWidget* pageView_; 
    ToolBarWidget* toolBar_; 
    ContentsWidget* contents_;

    QSize toolBarSize_;
    QSize pageSize_;
    QSize contentsSize_;

    QPushButton* fullScreenOff_;
    QPushButton* nextPage_;
    QPushButton* prevPage_;  
   

    bool fullScreenMode_;
    
};

#endif // MAINWINDOW_H
