#ifndef SELECTOR_H
#define SELECTOR_H

/*
  Kandis - A tea steepming timer.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Base/String.h>

#include <Lum/Dlg/ActionDialog.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Integer.h>
#include <Lum/Model/Selection.h>
#include <Lum/Model/String.h>
#include <Lum/Model/Table.h>

#include "Configuration.h"

typedef Lum::Model::StdRefTable<Tea,std::vector<Tea> > TeasModel;
typedef Lum::Base::Reference<TeasModel>                TeasModelRef;

class TeaObject : public Lum::Object
{
private:
  Lum::OS::FontRef font;
  Tea              tea;

public:
  TeaObject()
  : font(Lum::OS::display->GetFont())
  {
    // no code
  }

  void SetTea(const Tea& tea)
  {
    this->tea=tea;
  }

  void CalcSize()
  {
    minWidth=0;
    minHeight=font->height;

    width=minWidth;
    height=minHeight;

    Object::CalcSize();
  }

  void Draw(int x, int y, size_t w, size_t h)
  {
    Object::Draw(x,y,w,h);

    if (!OIntersect(x,y,w,h)) {
      return;
    }

    /* --- */

    Lum::OS::DrawInfo *draw=GetDrawInfo();

    draw->PushFont(font);
    draw->PushForeground(parent->GetTextColor(draw));

    //
    // Name of Tea
    //

    draw->DrawString(this->x,
                     this->y+font->ascent,
                     tea.name);

    //
    //
    // Time of tea

    std::wstring time=Lum::Base::NumberToWString(tea.minutes);

    time.append(L":");
    if (tea.seconds<10) {
      time.append(L"0");
    }
    time.append(Lum::Base::NumberToWString(tea.seconds));

    draw->DrawString(this->x+width-font->StringWidth(time),
                     this->y+font->ascent,
                     time);

    draw->PopFont();
    draw->PopForeground();
  }

  static TeaObject* Create(bool horizFlex, bool vertFlex)
  {
    TeaObject *object=new TeaObject();

    object->SetFlex(horizFlex,vertFlex);

    return object;
  }
};

class TeasDataProvider : public TeasModel::DataProvider
{
private:
  TeaObject *object;

public:
  TeasDataProvider()
   : object(TeaObject::Create(true,false))
  {
    // no code
  }

  ~TeasDataProvider()
  {
    delete object;
  }

  Lum::Object* GetObject(const TeasModel::Iterator& iter, size_t column) const
  {
    object->SetTea(*iter);
    return object;
  }
};

class Selector : public Lum::Dlg::ActionDialog
{
private:
  Lum::Model::SizeTRef               seconds;
  TeasModelRef                       list;
  Lum::Model::SingleLineSelectionRef selection;

  Lum::Model::ActionRef              addAction;
  Lum::Model::ActionRef              editAction;
  Lum::Model::ActionRef              removeAction;
  Lum::Model::ActionRef              okAction;

  bool                               success;

public:
  Selector(Lum::Model::SizeT *seconds);
  ~Selector();

  Lum::Object* GetContent();
  void GetActions(std::vector<Lum::Dlg::ActionInfo>& actions);

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);

  bool Success() const;
};

#endif
