/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef THEMESCHEDULERSETTINGS_H
#define THEMESCHEDULERSETTINGS_H

#include <QtGui/QDialog>
#include "themescheduler.h"

class QCheckBox;
class QScrollArea;
class QMaemo5ValueButton;
class QMaemo5TimePickSelector;
class QVBoxLayout;
class QListWidget;
class ThemePicker;

class ThemeSchedulerSettings : public QDialog
{
    Q_OBJECT

public:
    ThemeSchedulerSettings(QWidget* parent = 0);

signals:
    void themeChanged();

protected:
    void setVisible(bool visible);

private slots:
    void openAddDialog();
    void addScheduledTheme();
    void clearScheduler();
    void saveSettings();
    void showContextMenu(QPoint const& point);
    void removeCurrent();
    void removeSelection();

private:
    void loadItems();
    QCheckBox* enabled_;
    QVBoxLayout* layout_;
    QWidget* currentWidget_;
    QDialog* addDialog_;
    QMaemo5TimePickSelector* pickSelector_;
    QMaemo5ValueButton* timeButton_;
    ThemePicker* themePicker_;
    QList<ThemeScheduler::SchedulerItem> items_;
    QListWidget* itemList_;
};

#endif
