/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QString>
#include <QtGui/QGraphicsItem>
#include "effect.h"
#include "dropshadoweffect.h"
#include "blureffect.h"
#include "opacityeffect.h"
#include "flickereffect.h"


Effect::Effect()
{
}

Effect* Effect::getEffect(QString const& name)
{
   if(name == "dropshadow")
   {
       return new DropshadowEffect;
   }
   else if(name == "blur")
   {
       return new BlurEffect;
   }
   else if(name == "opacity")
   {
       return new OpacityEffect;
   }
   else if(name == "flicker")
   {
       return new FlickerEffect;
   }

   return 0;
}

int Effect::getAttribute(QString const& name,
                         QString const& value,
                         const Effect::AttributeDetails details[],
                         int count,
                         qreal& realValue)
{
    QString lower = name.toLower();

    for(int i = 0; i < count; i++)
    {
        if(details[i].name == lower)
        {
            if(!details[i].isQreal)
            {
                return i;
            }
            else
            {
                bool ok = true;
                double tmp = value.toDouble(&ok);

                if(ok)
                {
                    realValue = static_cast<qreal>(tmp);
                    return i;
                }
                else
                {
                    return -1;
                }
            }
        }
    }

    return -1;
}

