#ifndef _SGE_CORE_H_
#define _SGE_CORE_H_
#include <glib.h>
#include <SDL.h>
typedef struct s_sge_object
{
	gdouble x;
	gdouble y;
	gdouble vx;
	gdouble vy;
	gdouble ax;
	gdouble ay;
	gint dest_x;
	gint dest_y;
	gint width;
	gint height;
	gint layer;
	gint lifetime;
	gint needs_drawing;
	gint pixbuf_id;	
	gint (*stop_condition)(struct s_sge_object *);
	GFunc stop_callback;
}T_SGEObject;

extern void sge_init(void);
extern void sge_destroy(void);
extern void sge_set_drawing_area(SDL_Surface *drawing_area, gint x, gint y, gint width, gint height);

extern gint sge_register_pixbuf(SDL_Surface *pixbuf, int index);

extern T_SGEObject *sge_create_object(gint x, gint y, gint layer, gint pixbuf_id);
extern void sge_destroy_object(gpointer object, gpointer user_data);
extern void sge_destroy_all_objects(void);

extern void sge_object_set_lifetime(T_SGEObject *object, gint lifetime);
extern void sge_object_take_down(T_SGEObject *object);
extern void sge_object_move_to(T_SGEObject *object, gint dest_x, gint dest_y);
extern void sge_objects_fall_to(T_SGEObject *object, gint dest_y);

extern gboolean sge_object_is_moving(T_SGEObject *object);
extern gboolean sge_objects_are_moving(void);
extern gboolean sge_objects_are_moving_on_layer(int layer);
extern void sge_object_fall_to (T_SGEObject * object, gint y_pos);

extern void sge_invalidate_layer(int layer);
extern gboolean sge_main_loop (gpointer data);
extern SDL_Surface *sge_get_pixbuf (int index);

#endif
