#ifndef __BOARD_H__
#define __BOARD_H__
#include <glib.h>

#define BOARD_WIDTH 8
#define BOARD_HEIGHT 8
#define TILE_WIDTH 54
#define TILE_HEIGHT 54

#define BOARD_X 360
#define BOARD_Y (480 - 40 - (8 * 54))
#define BOARD_W (BOARD_WIDTH * TILE_WIDTH)
#define BOARD_H (BOARD_HEIGHT * TILE_HEIGHT)

#define TIME_X 352
#define TIME_Y (480 - 5 - 20)
#define TIME_W 400
#define TIME_H 20

#define QUIT_X 133
#define QUIT_H 30
#define QUIT_W 81
#define QUIT_Y (480 - 33 - QUIT_H)

#define RESTART_X  104
#define RESTART_W  146
#define RESTART_H  23
#define RESTART_Y  (480 - 122 - RESTART_H)

#ifdef MAEMO 
#define SAVE_PATH "/home/user/.gweled-save"
#else
#define SAVE_PATH get_path(1)
#endif

extern int gweled_gems_fall_into_place (void);
extern void gweled_draw_board (void);
extern void gweled_start_new_game (int load);
extern void gweled_refill_board (void);
extern gboolean board_engine_loop (gpointer data);
extern void gweled_click(int x, int y);
extern void gweled_release(int x, int y);

extern void gweled_save_game(void);
extern int gweled_load_game(void);
extern void display_current_score(void);
extern void display_multiply(void);
extern void display_time(float num);
extern void display_hi_score(void);
extern GRand *g_random_generator;

extern void gweled_draw_message_at (gchar * in_message, gint msg_x, gint msg_y);
extern void gweled_draw_message (gchar * in_message);
extern void gweled_draw_game_message (gchar * in_message, double timing);

extern gint gi_game_running;
extern gint gi_gem_clicked;
extern gint gi_x_click;
extern gint gi_y_click;

extern gint gi_high_score;
extern gint gi_notime_high_score;

extern void board_lock(void);
extern void board_unlock(void);
extern int g_timer_mode;
extern gint game_timer_mode;
extern int board_init(void);
extern void board_done(void);
#endif
