#include "main.h"

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "config.h"

#define swap(type, a, b) { type sw_ap; sw_ap=(a); (a)=(b); (b)=sw_ap; }

void show_alert(gchar* text)
{
	g_critical("%s", text);
	GtkWidget* banner;
	banner = hildon_banner_show_information_with_markup(NULL, NULL, text);
	hildon_banner_set_timeout(HILDON_BANNER(banner), 5000);
}

static void my_connection_handler(ConIcConnection *connection, ConIcConnectionEvent *event, gpointer user_data)
{
	ConIcConnectionStatus status = con_ic_connection_event_get_status(event);
	ConIcConnectionError error;

	switch (status)
	{
		case CON_IC_STATUS_CONNECTED:
			translate();
			break;
		case CON_IC_STATUS_DISCONNECTING:
			show_alert("Now disconnecting...");
			break;
		case CON_IC_STATUS_DISCONNECTED:
			show_alert("No internet connection!");
			break;
		default:
			show_alert("Unknown status!");
	}
}

void connect_internet(GtkWidget* widget, gpointer data)
{
	gboolean success = FALSE;
	ConIcConnection *connection = con_ic_connection_new();
	g_signal_connect(G_OBJECT(connection), "connection-event", G_CALLBACK(my_connection_handler), NULL);
	success = con_ic_connection_connect(connection, CON_IC_CONNECT_FLAG_NONE);
	//if (!success) show_alert("No internet connection!");
}

void translate()
{	
	SoupSession* session = soup_session_async_new_with_options(SOUP_SESSION_USER_AGENT, "gTranslate/0.5", NULL);
	
	GtkTextIter start;
	GtkTextIter end;
	gchar* text;

	gtk_text_buffer_get_start_iter(buffer_source, &start);
	gtk_text_buffer_get_end_iter(buffer_source, &end);
	text = gtk_text_buffer_get_text(buffer_source, &start, &end, FALSE);
	
	if (g_strcmp0(text, "") == 0)
	{
		show_alert("Please enter valid text!");
		return;
	}
	
	SoupMessage* msg;
	gchar* url = g_strdup_printf("http://www.google.com/translate_a/t?client=gtranslate&ie=UTF-8&sl=%s&tl=%s&ie=utf-8&oe=utf-8",
										languages[index_src_lang].str_short, languages[index_tar_lang].str_short);
	msg = soup_message_new("POST", url);
	g_free(url);
	gchar* formdata = g_strdup_printf("&text=%s", g_uri_escape_string(text, NULL, TRUE));
	g_free(text);
	
	g_debug("Translate this: %s\n", formdata);
	
	soup_message_set_request(msg, "application/x-www-form-urlencoded", SOUP_MEMORY_COPY, formdata, strlen(formdata));
	
	guint status;
	status = soup_session_send_message(session, msg);
	
	/*if (status != 200) // or status == 2
	{
		show_alert("No internet connection!");
		return;
	}*/
	
	g_debug("Status: %d\n", status);
	
	g_print("Got this: %s\n", msg->response_body->data);
	
	g_free(formdata);
	
	JsonParser* parser;
	JsonNode* root;
	
	parser = json_parser_new();
	json_parser_load_from_data(parser, msg->response_body->data, -1, NULL);

	root = json_parser_get_root(parser);
	
	if (!json_object_has_member(json_node_get_object(root), "sentences"))
	{
		show_alert("Please enter valid text!");
		return;
	}

	GString* final_text = g_string_new("");

	JsonArray* sentences = json_object_get_array_member(json_node_get_object(root), "sentences");
	
	int i;
	
	GString* final_trans    = g_string_new("");
	GString* final_translit = g_string_new("(");
	
	for (i = 0; i < json_array_get_length(sentences); i++)
	{
		JsonObject* trans = json_array_get_object_element(sentences, i);
		gchar* translated_text = g_strdup_printf("%s", json_object_get_string_member(trans, "trans"));
		g_string_append(final_trans, translated_text);
		g_free(translated_text);
	
		gchar* translit = g_strdup_printf("%s", json_object_get_string_member(trans, "translit"));
		g_string_append(final_translit, translit);
		g_free(translit);
		
		//g_print("-- translit -------------\n%s\n", translit);
	}
	
	g_string_append(final_text, final_trans->str);
	g_string_append(final_text, "\n");
	
	g_string_append(final_translit, ")\n\n");
	
	if (g_strcmp0(final_translit->str, "()\n\n"))
	{
		g_string_append(final_text, final_translit->str);
	}
	else
	{
		g_string_append(final_text, "\n");
	}
	
	g_string_free(final_trans, TRUE);
	g_string_free(final_translit, TRUE);
	
	/*if (g_strcmp0(translit, ""))
	{
		gchar* tmp_translit = g_strdup_printf("(%s)\n",  translit);
		g_string_append(final_text, tmp_translit);
		g_free(tmp_translit);
	}
	
	g_string_append(final_text, "\n");*/

	if (json_object_has_member(json_node_get_object(root), "dict"))
	{
		JsonArray* dict = json_object_get_array_member(json_node_get_object(root), "dict");
		//GList* tmp1 = json_array_get_elements(dict);
	
		for (i = 0; i < json_array_get_length(dict); i++)
		{
			JsonObject* dict1 = json_array_get_object_element(dict, i);
			//JsonObject* dict1 = (JsonObject*)tmp1->data;
			JsonArray* terms = json_object_get_array_member(dict1, "terms");
			
			gchar* word_class = g_strdup_printf("%s\n", json_object_get_string_member(dict1, "pos"));
			//g_print("-- %s ----------\n", word_class);
			GList* terms_list = json_array_get_elements(terms);
			
			if (g_strcmp0(word_class, "\n"))
				g_string_append(final_text, word_class);
			else
				g_string_append(final_text, "Unknown\n");
			
			g_free(word_class);
	
			GList* tmp;
	
			for (tmp = terms_list; tmp; tmp=tmp->next)
			{
				JsonNode* wrapper = (JsonNode*)tmp->data;
				gchar* word = g_strdup_printf("  %s\n", json_node_get_string(wrapper));
				g_string_append(final_text, word);
				//g_print("%s\n", json_node_get_string(wrapper));
				g_free(word);
			}
			
			//g_string_append(final_text, "\n");
		}
	}

	g_object_unref(parser);
	
	gtk_text_buffer_set_text(buffer_translated, final_text->str, -1);
	
	//g_free(translated_text);
	g_string_free(final_text, TRUE);
}

void swap_languages(GtkWidget* widget, gpointer data)
{
	/* Swap selected languages indeces */
	swap(gint, index_src_lang, index_tar_lang);
	
	/* Swap texts in textfields */
	GtkTextIter start;
	GtkTextIter end;

	gtk_text_buffer_get_start_iter(buffer_source, &start);
	gtk_text_buffer_get_end_iter(buffer_source, &end);
	gchar* text1 = gtk_text_buffer_get_text(buffer_source, &start, &end, FALSE);

	gtk_text_buffer_get_start_iter(buffer_translated, &start);
	gtk_text_buffer_get_end_iter(buffer_translated, &end);
	gchar* text2 = gtk_text_buffer_get_text(buffer_translated, &start, &end, FALSE);
	
	gtk_text_buffer_set_text(buffer_source,     text2, -1);
	gtk_text_buffer_set_text(buffer_translated, text1, -1);
	
	g_free(text1);
	g_free(text2);
	
	/* Swap flags and text in buttons */
	hildon_button_set_value(HILDON_BUTTON(button_src_lang), languages[index_src_lang].str_long);
	settings_int_set("default", "src_lang", index_src_lang);
	hildon_button_set_image(HILDON_BUTTON(button_src_lang), gtk_image_new_from_pixbuf(flags[index_src_lang]));

	hildon_button_set_value(HILDON_BUTTON(button_tar_lang), languages[index_tar_lang].str_long);
	settings_int_set("default", "tar_lang", index_tar_lang);
	hildon_button_set_image(HILDON_BUTTON(button_tar_lang), gtk_image_new_from_pixbuf(flags[index_tar_lang]));
	
	gtk_widget_set_sensitive(button_say1, languages[index_src_lang].espeak);
	gtk_widget_set_sensitive(button_say2, languages[index_tar_lang].espeak);
}

extern void paste_text(GtkWidget* widget, gpointer data)
{
	gtk_text_buffer_paste_clipboard(buffer_source, clipboard, NULL, TRUE);
}

extern void copy_text(GtkWidget* widget, gpointer data)
{
	GtkTextIter start;
	GtkTextIter end;

	gtk_text_buffer_get_bounds(buffer_translated, &start, &end);
	gtk_text_buffer_move_mark_by_name(buffer_translated, "insert", &end);
	gtk_text_buffer_move_mark_by_name(buffer_translated, "selection_bound", &start);
	
	gtk_text_buffer_copy_clipboard(buffer_translated, clipboard);
}

void row_activated(GtkWidget* tree_view, GtkTreePath* path, GtkTreeViewColumn* column, gpointer data)
{
	gint n = (gtk_tree_path_get_indices(path))[0];

	gchar* language_string;
	GtkTreeIter iter;

	GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(tree_view));
	gtk_tree_model_get_iter (GTK_TREE_MODEL (model), &iter, path);

	gtk_tree_model_get(model, &iter, 0, &language_string, -1);
	//g_debug("%s\n", language_string);
	
	if ((gint)data == 2)
	{
		n++;
	}
	
	if (g_strcmp0(language_string, languages[n].str_long) != 0)
	{
		//g_debug("search on!\n");
		
		for (n = 0; n < 52; n++)
		{
			if (g_strcmp0(language_string, languages[n].str_long) == 0)
			{
				//g_debug("%s = %s\n", language_string, languages[n].str_long);
				break;
			}
		}
	}
	/*else
	{
		g_debug("search off!\n");
	}*/
	
	if ((gint)data == 1)
	{
		hildon_button_set_value(HILDON_BUTTON(button_src_lang), languages[n].str_long);
		settings_int_set("default", "src_lang", n);
		index_src_lang = n;
		hildon_button_set_image(HILDON_BUTTON(button_src_lang), gtk_image_new_from_pixbuf(flags[n]));
		gtk_widget_set_sensitive(button_say1, languages[n].espeak);
		
		if (n == 0)
		{
			gtk_widget_set_sensitive(button_swap, FALSE);
		}
		else
		{
			gtk_widget_set_sensitive(button_swap, TRUE);
		}
	}
	else
	{
		hildon_button_set_value(HILDON_BUTTON(button_tar_lang), languages[n].str_long);
		settings_int_set("default", "tar_lang", n);
		index_tar_lang = n;
		hildon_button_set_image(HILDON_BUTTON(button_tar_lang), gtk_image_new_from_pixbuf(flags[n]));
		gtk_widget_set_sensitive(button_say2, languages[n].espeak);
	}
	
 	gtk_widget_destroy(dialog);
}

void show_about(GtkWidget* widget, gpointer data)
{
	GtkWidget* about_dialog;
	about_dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(about_dialog), "About "PACKAGE_STRING);
	gtk_window_set_transient_for(GTK_WINDOW(about_dialog), GTK_WINDOW(window));
	/*GtkWidget* table = gtk_table_new(3, 2, TRUE);
	
	about_dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(about_dialog), "About "PACKAGE_STRING);
	gtk_window_set_transient_for(GTK_WINDOW(about_dialog), GTK_WINDOW(window));
	
	GtkWidget* label_tomppas = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label_tomppas), "<b>Programming, flags:</b>\nTomppaS");
	gtk_table_attach_defaults(GTK_TABLE(table), label_tomppas, 0, 1, 0, 1);
	
	GtkWidget* label_joppu = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label_joppu), "<b>Icons:</b>\njoppu");
	gtk_table_attach_defaults(GTK_TABLE(table), label_joppu, 1, 2, 0, 1);
	
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new("Powered by:"), 0, 2, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_image_new_from_file(DATAPREFIX"/google.png"), 0, 2, 2, 3);
	
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(about_dialog)->vbox), table);*/
	
	GtkWidget* text = hildon_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(text), FALSE);
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(text), FALSE);
	
	GdkPixbuf* google_translate = gdk_pixbuf_new_from_file(DATAPREFIX"/google.png", NULL);
	
	GtkTextBuffer* buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	
	GtkTextIter iter;
	gtk_text_buffer_get_end_iter(buffer, &iter);
	
	gtk_text_buffer_insert(buffer, &iter, "Programming and flag graphics:\n  TomppaS\n\nIcons:\n  Joppu\n\nPowered by:\n  eSpeak: Speech Synthesizer\n  ", -1);
	
	gtk_text_buffer_insert_pixbuf(buffer, &iter, google_translate);
	
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(about_dialog)->vbox), text);
	
	gtk_widget_show_all(about_dialog);
}

GtkWidget* settings_dialog;

/*GtkWidget* radio_male;
GtkWidget* radio_female;*/

GtkWidget* slider_pitch;
GtkWidget* slider_speed;
GtkWidget* slider_wordgap;

void settings_response(GtkDialog* dialog, gint response_id, gpointer user_data)
{
	if (response_id == GTK_RESPONSE_OK)
	{
		settings_int_set("voice", "pitch", (gint)gtk_range_get_value(GTK_RANGE(slider_pitch)));
		settings_int_set("voice", "speed", (gint)gtk_range_get_value(GTK_RANGE(slider_speed)));
		settings_int_set("voice", "wordgap", (gint)gtk_range_get_value(GTK_RANGE(slider_wordgap)));
		
		/*if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_male)))
		{
			settings_int_set("voice", "gender", 1);
		}
		else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_female)))
		{
			settings_int_set("voice", "gender", 2);
		}*/
		
		gtk_widget_destroy(GTK_DIALOG(settings_dialog));
	}
}

void show_settings(GtkWidget* widget, gpointer data)
{
	settings_dialog = gtk_dialog_new_with_buttons("Settings", window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_SAVE, GTK_RESPONSE_OK, NULL);
	//gtk_window_set_title(GTK_WINDOW(settings_dialog), "Settings");
	gtk_window_set_transient_for(GTK_WINDOW(settings_dialog), GTK_WINDOW(window));
	
	//GtkWidget* caption_speech = gtk_label_new("Speech Synthesizer");
	
	/*radio_male = hildon_gtk_radio_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
	gtk_button_set_label(GTK_BUTTON(radio_male), "Male");
	gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(radio_male), FALSE);
	
	radio_female = hildon_gtk_radio_button_new(HILDON_SIZE_FINGER_HEIGHT, gtk_radio_button_get_group(GTK_RADIO_BUTTON(radio_male)));
	gtk_button_set_label(GTK_BUTTON(radio_female), "Female");
	gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(radio_female), FALSE);*/
	
	/*if (settings_int_get("voice", "gender", 1) == 1)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_male), TRUE);
	}
	else
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_female), TRUE);
	}*/
	
	/*GtkWidget* gender_hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(gender_hbox), radio_male,   TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(gender_hbox), radio_female, TRUE, TRUE, 0);*/
	
	slider_pitch = gtk_hscale_new_with_range(-50.0, 50.0, 1.0);
	gtk_scale_set_value_pos(GTK_SCALE(slider_pitch), GTK_POS_RIGHT);
	gtk_range_set_value(GTK_RANGE(slider_pitch), (gdouble)settings_int_get("voice", "pitch", 0));
	
	slider_speed = gtk_hscale_new_with_range(80.0, 390.0, 2.0);
	gtk_scale_set_value_pos(GTK_SCALE(slider_speed), GTK_POS_RIGHT);
	gtk_range_set_value(GTK_RANGE(slider_speed), (gdouble)settings_int_get("voice", "speed", 181));
	
	slider_wordgap = gtk_hscale_new_with_range(0.0, 20.0, 1.0);
	gtk_scale_set_value_pos(GTK_SCALE(slider_wordgap), GTK_POS_RIGHT);
	gtk_range_set_value(GTK_RANGE(slider_wordgap), (gdouble)settings_int_get("voice", "wordgap", 5));
	
	GtkWidget* vbox = gtk_vbox_new(TRUE, 0);
	//gtk_box_pack_start(GTK_BOX(vbox), caption_speech, FALSE, TRUE, 0);
	//gtk_box_pack_start(GTK_BOX(vbox), hildon_caption_new(NULL, "Gender\t\t", gender_hbox,    NULL, 0),  FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hildon_caption_new(NULL, "Pitch\t\t",  slider_pitch,   NULL, 0),  FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hildon_caption_new(NULL, "Speed\t\t",  slider_speed,   NULL, 0),  FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hildon_caption_new(NULL, "Word gap\t", slider_wordgap, NULL, 0),  FALSE, TRUE, 0);
	
	GtkWidget* frame_speech = gtk_frame_new("Speech Synthesizer");
	gtk_container_add(GTK_CONTAINER(frame_speech), vbox);
	
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(settings_dialog)->vbox), frame_speech);
	
	g_signal_connect_swapped(settings_dialog, "response", G_CALLBACK(settings_response), NULL);
	
	gtk_widget_show_all(settings_dialog);
}

static gboolean filter_func(GtkTreeModel* model, GtkTreeIter* iter, gchar* text, gpointer data)
{
	gboolean retvalue;
	gchar* rowtext = NULL;

	gtk_tree_model_get(model, iter, 0, &rowtext, -1);
	retvalue = g_str_has_prefix(g_utf8_strup(rowtext, -1), g_utf8_strup(text, -1));
	g_free(rowtext);

	return retvalue;
}

void change_language(GtkWidget* widget, gpointer data)
{
	dialog = gtk_dialog_new();
	
	gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(window));
	
	if ((gint)data == 1)
		gtk_window_set_title(GTK_WINDOW(dialog), "Select source language");
	else
		gtk_window_set_title(GTK_WINDOW(dialog), "Select target language");
	
	GtkCellRenderer* renderer;
	GtkCellRenderer* renderer_pixbuf;
	GtkTreeViewColumn* column;
	GtkListStore* store;
	GtkWidget* view;
	GtkTreeIter iter;
	GtkTreeModel* filter;
	
	//view = gtk_tree_view_new();
	store = gtk_list_store_new(2, G_TYPE_STRING, GDK_TYPE_PIXBUF);
	
	int n;
	for (n = (int)data-1; n < 52; n++)
	{
		gtk_list_store_append(store, &iter);
		gtk_list_store_set(store, &iter, 0, languages[n].str_long, 1, flags[n], -1);
	}
	
	filter = gtk_tree_model_filter_new(GTK_TREE_MODEL(store), NULL);
	//gtk_tree_view_set_model(GTK_TREE_VIEW(view), filter);
	view = gtk_tree_view_new_with_model(filter);
	
    GtkWidget* live;
    live = hildon_live_search_new();
    hildon_live_search_set_filter(HILDON_LIVE_SEARCH(live), GTK_TREE_MODEL_FILTER(filter));
    hildon_live_search_set_visible_func(HILDON_LIVE_SEARCH(live), filter_func, NULL, NULL);
    hildon_live_search_widget_hook(HILDON_LIVE_SEARCH(live), dialog, view);
	
	//GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	GtkWidget* pan_area = hildon_pannable_area_new();
	gtk_widget_set_size_request(pan_area, 800, 480);
	gtk_container_add(GTK_CONTAINER(pan_area), view);
	
	GtkWidget* vbox = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), pan_area, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), live,     FALSE, FALSE, 0);
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), vbox);
	
	gtk_widget_show_all(GTK_WIDGET(dialog));
	
	renderer = gtk_cell_renderer_text_new();
	renderer_pixbuf = gtk_cell_renderer_pixbuf_new();
	
	column = gtk_tree_view_column_new_with_attributes("Flag", renderer_pixbuf, "pixbuf", 1, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(view), column);
	
	column = gtk_tree_view_column_new_with_attributes("Language", renderer, "text", 0, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(view), column);
	
	g_signal_connect(G_OBJECT(view), "row-activated", G_CALLBACK(row_activated), (gpointer)data);
	
	GdkRectangle rect;
	GtkTreePath* path;
	gint y;
	
	if ((gint)data == 1)
		path = gtk_tree_path_new_from_indices(index_src_lang, -1);
	else
		path = gtk_tree_path_new_from_indices(index_tar_lang, -1);
	
	gtk_tree_view_get_background_area(GTK_TREE_VIEW(view), path, NULL, &rect);
	gtk_tree_view_convert_bin_window_to_tree_coords(GTK_TREE_VIEW(view), 0, rect.y, NULL, &y);
	hildon_pannable_area_jump_to(HILDON_PANNABLE_AREA(pan_area), -1, y);
	
	gtk_tree_path_free(path);
	g_object_unref(store);
	g_object_unref(filter);
	
    /*GdkRectangle rect;
    gint y;
    GtkTreePath* path;

	path = gtk_tree_model_get_path(GTK_TREE_MODEL(store), &iter);
    gtk_tree_view_get_background_area(view, path, NULL, &rect);
    gtk_tree_view_convert_bin_window_to_tree_coords(view, 0, rect.y, NULL, &y);
    
    g_critical("%d", y);
    
    if ((gint)data == 1)
    	hildon_pannable_area_jump_to(HILDON_PANNABLE_AREA(pan_area), -1, y/80*index_src_lang);
    else
    	hildon_pannable_area_jump_to(HILDON_PANNABLE_AREA(pan_area), -1, y/80*index_tar_lang);
    
    gtk_tree_path_free(path);*/
	
	//gtk_dialog_run(GTK_DIALOG(dialog));
}

void clear_text(GtkWidget* widget, gint data)
{
	if (data == 1)
	{
		gtk_text_buffer_set_text(buffer_source, "", -1);
	}
	else
	{
		gtk_text_buffer_set_text(buffer_translated, "", -1);
	}
}

void say_text(GtkWidget* widget, gint data)
{
	GtkTextIter start;
	GtkTextIter end;
	gchar* text;
	gchar* lang;
	
	if (data == 1)
	{
		gtk_text_buffer_get_start_iter(buffer_source, &start);
		gtk_text_buffer_get_end_iter(buffer_source, &end);
		text = gtk_text_buffer_get_text(buffer_source, &start, &end, FALSE);
		lang = g_strdup(languages[index_src_lang].str_short);
	}
	else
	{
		gtk_text_buffer_get_start_iter(buffer_translated, &start);
		gtk_text_buffer_get_end_iter(buffer_translated, &end);
		text = gtk_text_buffer_get_text(buffer_translated, &start, &end, FALSE);
		lang = g_strdup(languages[index_tar_lang].str_short);
	}
	
	espeak_Initialize(AUDIO_OUTPUT_PLAYBACK, 0, NULL, 0);
	
	espeak_SetVoiceByName(lang);
	
	/*espeak_VOICE *voice_spec = espeak_GetCurrentVoice();
	voice_spec->gender = (char)settings_int_get("voice", "gender", 1) + 48;
	espeak_SetVoiceByProperties(voice_spec);
	
	g_debug("gender = %c\n", voice_spec->gender);*/
	
	espeak_SetParameter(espeakRATE,    settings_int_get("voice", "speed", 181), 0);
	espeak_SetParameter(espeakPITCH,   settings_int_get("voice", "pitch", 0) + 50, 0);
	espeak_SetParameter(espeakWORDGAP, settings_int_get("voice", "wordgap", 5), 0);
	
	espeak_Synth(text,strlen(text)+1,0,POS_CHARACTER,0,0,NULL,NULL);
	espeak_Synchronize();
	espeak_Terminate();
	
	g_free(text);
	g_free(lang);
}
